/* Live currency formatting for inputs with class 'currency' */
(function(){
    function toNumber(str){
        return (str || '').toString().replace(/[^0-9]/g,'');
    }

    function formatRupiah(value){
        var s = toNumber(value);
        if(s === '') return '';
        // add thousand separators
        return 'Rp ' + s.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    }

    function onInput(e){
        var el = e.target;
        var caret = el.selectionStart;
        var raw = toNumber(el.value);
        if(raw === ''){ el.value = ''; return; }
        var formatted = 'Rp ' + raw.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        el.value = formatted;
        // move caret to end
        el.setSelectionRange(el.value.length, el.value.length);
    }

    function stripBeforeSubmit(e){
        var forms = document.querySelectorAll('form');
        forms.forEach(function(form){
            form.addEventListener('submit', function(){
                var inputs = form.querySelectorAll('input.currency');
                inputs.forEach(function(inp){
                    inp.value = toNumber(inp.value);
                });
            });
        });
    }

    document.addEventListener('DOMContentLoaded', function(){
        var inputs = document.querySelectorAll('input.currency');
        inputs.forEach(function(i){
            i.addEventListener('input', onInput);
            // initialize if has value
            if(i.value){ i.value = formatRupiah(i.value); }
        });
        stripBeforeSubmit();
    });
})();
