// JS for Barang form: preview, kategori modal/ajax, and kode preview
// If a leftover fallback backdrop exists (from previous fallback runs), remove it so page remains clickable
try{
    if (typeof document !== 'undefined'){
        var __bd = document.getElementById('kategoriModalBackdrop');
        if(__bd){ __bd.parentNode.removeChild(__bd); document.body.classList.remove('modal-open'); }
    }
}catch(e){}

(function(){
    'use strict';

    function previewImage(e, container){
        var file = e.target.files && e.target.files[0];
        var out = document.querySelector(container);
        if(!out) return;
        out.innerHTML = '';
        if (!file) return;
        var reader = new FileReader();
        reader.onload = function(ev){
            var img = document.createElement('img');
            img.src = ev.target.result;
            img.style.maxWidth = '200px';
            out.appendChild(img);
        };
        reader.readAsDataURL(file);
    }

    // global modal reference and helpers (so attachKategoriFormHandler can use them)
    var __currentKategoriModal = null;

    function cleanupBackdrop(){
        try{
            // remove any leftover backdrops
            var bds = document.querySelectorAll('.modal-backdrop');
            bds.forEach(function(b){ if(b && b.parentNode) b.parentNode.removeChild(b); });
            var specific = document.getElementById('kategoriModalBackdrop'); if(specific && specific.parentNode) specific.parentNode.removeChild(specific);
            document.body.classList.remove('modal-open');
        }catch(e){}
    }

    function handleEscapeOnce(e){
        if(e.key === 'Escape' || e.key === 'Esc'){
            if(__currentKategoriModal && typeof __currentKategoriModal.hide === 'function'){
                try{ __currentKategoriModal.hide(); }catch(err){}
            }
        }
    }

    function openKategoriModal(type, id) {
        var url = 'index.php?r=kategori/' + (type === 'create' ? 'create' : ('update&id=' + id));
        fetch(url, { headers: { 'X-Requested-With': 'XMLHttpRequest' } })
            .then(function(r){ return r.text(); })
            .then(function(html){
                var body = document.getElementById('kategoriModalBody');
                if(!body) return;
                body.innerHTML = html;
                var modalEl = document.getElementById('kategoriModal');
                var modalObj = null;
                if (window.bootstrap && bootstrap.Modal) {
                    modalObj = new bootstrap.Modal(modalEl);
                    modalObj.show();
                } else {
                    // fallback: simple show
                    modalEl.classList.add('show');
                    modalEl.style.display = 'block';
                    document.body.classList.add('modal-open');
                    var backdrop = document.createElement('div');
                    backdrop.className = 'modal-backdrop fade show';
                    backdrop.id = 'kategoriModalBackdrop';
                    document.body.appendChild(backdrop);
                    modalObj = {
                        hide: function(){
                            modalEl.classList.remove('show');
                            modalEl.style.display = 'none';
                            var bd = document.getElementById('kategoriModalBackdrop'); if(bd) bd.parentNode.removeChild(bd);
                            document.body.classList.remove('modal-open');
                        }
                    };
                    // clicking on fallback backdrop should close modal
                    backdrop.addEventListener('click', function(){ try{ modalObj.hide(); }catch(err){} });
                }
                // ensure any close buttons inside modal call modalObj.hide() (covers fallback and non-bootstrap cases)
                try{
                    var closeButtons = modalEl.querySelectorAll('[data-bs-dismiss], .btn-close');
                    closeButtons.forEach(function(btn){
                        // avoid double-binding
                        if(btn._kategoriBound) return; btn._kategoriBound = true;
                        btn.addEventListener('click', function(e){
                            try{ modalObj.hide(); }catch(err){}
                        });
                    });
                }catch(e){}

                // attach cleanup handlers for bootstrap modal events (if available)
                try{
                    if(modalEl && modalEl.addEventListener){
                        modalEl.addEventListener('hidden.bs.modal', function(){ cleanupBackdrop(); document.removeEventListener('keydown', handleEscapeOnce); __currentKategoriModal = null; });
                    }
                }catch(e){}

                // attach keydown handler to close on Escape
                try{ document.addEventListener('keydown', handleEscapeOnce); }catch(e){}

                __currentKategoriModal = modalObj;

                attachKategoriFormHandler(modalObj);
            }).catch(function(){ /* ignore */ });
    }

    function attachKategoriFormHandler(modal){
        var form = document.querySelector('#kategoriModalBody form');
        if(!form) return;
        // prevent double-binding
        if(form._bound) return; form._bound = true;
        form.addEventListener('submit', function(e){
            e.preventDefault();
            var formData = new FormData(form);
            var meta = document.querySelector('meta[name="csrf-token"]');
            var csrfToken = meta ? meta.getAttribute('content') : '';
            fetch(form.action, { method: 'POST', body: formData, headers: { 'X-CSRF-Token': csrfToken, 'X-Requested-With': 'XMLHttpRequest' }, credentials: 'same-origin' })
                .then(function(r){ return r.text(); })
                .then(function(text){
                    // try parse JSON first
                    try{
                        var data = JSON.parse(text);
                        if(data && data.success){
                            try{ modal.hide(); }catch(e){}
                            refreshKategoriList(data.id);
                            return;
                        }
                    }catch(err){
                        // not JSON, continue
                    }
                    // If server returned HTML fragment containing a form, replace modal body and reattach handler
                    if(text && text.indexOf('<form') !== -1){
                        var body = document.getElementById('kategoriModalBody');
                        body.innerHTML = text;
                        attachKategoriFormHandler(modal);
                        return;
                    }
                    // Otherwise assume server redirected / returned full page; close modal and refresh list to keep UI consistent
                    try{ modal.hide(); }catch(e){}
                    refreshKategoriList();
                }).catch(function(){ alert('Gagal menyimpan kategori'); });
        });
    }

    function refreshKategoriList(selectId){
        var sel = document.getElementById('barang-kategori');
        if(!sel) return;
        fetch('index.php?r=kategori/list-json', { headers: { 'X-Requested-With': 'XMLHttpRequest' } })
            .then(function(r){ return r.json(); })
            .then(function(list){
                sel.innerHTML = '<option value="">-- Pilih Kategori --</option>';
                list.forEach(function(item){
                    var opt = document.createElement('option');
                    opt.value = item.nama;
                    opt.setAttribute('data-id', item.id);
                    opt.textContent = item.nama;
                    sel.appendChild(opt);
                });
                if(selectId){
                    var toSelect = Array.from(sel.options).find(function(o){ return o.getAttribute('data-id') == selectId; });
                    if(toSelect) toSelect.selected = true;
                }
            }).catch(function(){ /* ignore */ });
    }

    // initializer that can be called on page load or after AJAX-inserted form
    window.initBarangForm = function(root){
        root = root || document;
        try{ cleanupBackdrop(); }catch(e){}
        window.previewImage = previewImage;
        var nama = root.getElementById ? root.getElementById('barang-nama') : null; if(nama) nama.focus();

        // kode preview
        var kodeInput = root.querySelector ? root.querySelector('#barang-kode_barang') : null;
        if(kodeInput && kodeInput.value.trim() === ''){
            fetch('index.php?r=barang/next-kode')
                .then(function(r){ return r.json(); })
                .then(function(data){ if(data && data.kode) kodeInput.value = data.kode; })
                .catch(function(){ /* ignore */ });
        }

        // category buttons
        var addBtn = root.querySelector ? root.querySelector('#kategori-add-btn') : null;
        var editBtn = root.querySelector ? root.querySelector('#kategori-edit-btn') : null;
        var delBtn = root.querySelector ? root.querySelector('#kategori-del-btn') : null;
        var sel = root.querySelector ? root.querySelector('#barang-kategori') : null;
        if(addBtn){ addBtn.addEventListener('click', function(){ openKategoriModal('create'); }); }
        if(editBtn){ editBtn.addEventListener('click', function(){
            var opt = sel && sel.options ? sel.options[sel.selectedIndex] : null; var id = opt ? opt.getAttribute('data-id') : null; if(!id){ alert('Pilih kategori untuk diubah'); return; } openKategoriModal('update', id);
        }); }
        if(delBtn){ delBtn.addEventListener('click', function(){
            var opt = sel && sel.options ? sel.options[sel.selectedIndex] : null; var id = opt ? opt.getAttribute('data-id') : null; if(!id){ alert('Pilih kategori untuk dihapus'); return; } if(!confirm('Hapus kategori ini?')) return; var meta = document.querySelector('meta[name="csrf-token"]'); var csrfToken = meta ? meta.getAttribute('content') : ''; fetch('index.php?r=kategori/delete&id=' + id, { method: 'POST', headers: { 'X-CSRF-Token': csrfToken, 'X-Requested-With': 'XMLHttpRequest' } }).then(function(r){ return r.json(); }).then(function(data){ if(data && data.success){ refreshKategoriList(); } else { alert('Gagal menghapus'); } }).catch(function(){ alert('Gagal menghapus'); });
        }); }

        // expose helpers globally
        window.openKategoriModal = openKategoriModal;
        window.refreshKategoriList = refreshKategoriList;

        // Before form submit, strip currency formatting so client validation accepts numeric value
        try{
            var barangFormEl = (root.querySelector ? root.querySelector('.barang-form form') : null) || document.querySelector('.barang-form form');
            if(barangFormEl){
                // avoid duplicate binding
                if(!barangFormEl._currencyBound){
                    barangFormEl._currencyBound = true;
                    barangFormEl.addEventListener('submit', function(e){
                        var inputs = barangFormEl.querySelectorAll('.currency');
                        inputs.forEach(function(inp){
                            if(!inp.value) return;
                            inp.value = inp.value.replace(/[^0-9]/g, '');
                        });
                    }, true);
                }
            }
        }catch(e){}

        // Two-element currency: synchronize display field with hidden numeric field
        try{
            var display = root.querySelector ? root.querySelector('#barang-harga-display') : document.getElementById('barang-harga-display');
            var hidden = root.querySelector ? root.querySelector('#barang-harga') : document.getElementById('barang-harga');
            function formatIDNumber(digits){
                if(!digits) return '';
                digits = digits.replace(/^0+/, '') || '0';
                var s = digits.split('').reverse().join('').match(/.{1,3}/g).join('.').split('').reverse().join('');
                return s;
            }
            function onlyDigits(str){ return (str||'').toString().replace(/[^0-9]/g,''); }
            if(display && hidden){
                if(hidden.value === '' && display.value){ hidden.value = onlyDigits(display.value); }
                var onInput = function(e){
                    var raw = onlyDigits(display.value);
                    hidden.value = raw;
                    if(raw === ''){ display.value = ''; } else { display.value = 'Rp ' + formatIDNumber(raw); }
                    try{ display.selectionStart = display.selectionEnd = display.value.length; }catch(err){}
                };
                display.addEventListener('input', onInput);
                display.addEventListener('blur', function(){ var raw = onlyDigits(display.value); display.value = raw ? ('Rp ' + formatIDNumber(raw)) : ''; });
                display.addEventListener('paste', function(){ setTimeout(onInput, 20); });
            }
        }catch(e){}
    };

    // run on initial page load
    document.addEventListener('DOMContentLoaded', function(){ window.initBarangForm(document); });

    // global delegation for action buttons in barang index (view/update/delete)
    document.addEventListener('click', function(e){
        try{
            var a = e.target.closest ? e.target.closest('a.action-view, a.action-update') : null;
            if(a){
                e.preventDefault();
                var url = a.getAttribute('data-url') || a.href;
                // load into modal
                fetch(url, { headers: { 'X-Requested-With': 'XMLHttpRequest' } })
                    .then(function(r){ return r.text(); })
                    .then(function(html){
                        var modal = document.getElementById('modal-create-barang');
                        if(!modal) return;
                        modal.querySelector('.modal-content').innerHTML = html;
                        if(window.bootstrap && bootstrap.Modal){
                            var m = new bootstrap.Modal(modal);
                            m.show();
                        } else {
                            modal.classList.add('show'); modal.style.display = 'block'; document.body.classList.add('modal-open');
                        }
                        try{ if(typeof window.initBarangForm === 'function') window.initBarangForm(modal); }catch(err){}
                    }).catch(function(){ alert('Gagal memuat halaman'); });
                return;
            }
            var d = e.target.closest ? e.target.closest('a.action-delete') : null;
            if(d){
                e.preventDefault();
                if(!confirm('Hapus item ini?')) return;
                var url = d.getAttribute('data-url') || d.href;
                var meta = document.querySelector('meta[name="csrf-token"]');
                var csrfToken = meta ? meta.getAttribute('content') : '';
                fetch(url, { method: 'POST', headers: { 'X-CSRF-Token': csrfToken, 'X-Requested-With': 'XMLHttpRequest' } })
                    .then(function(r){ return r.json(); })
                    .then(function(data){ if(data && data.success){ location.reload(); } else { alert('Gagal menghapus'); } })
                    .catch(function(){ alert('Gagal menghapus'); });
                return;
            }
        }catch(err){/* ignore */}
    });

})();
