<?php
use yii\helpers\Html;

$this->title = 'User: ' . $model->username;
?>
<div class="user-view container">
    <h3><?= Html::encode($this->title) ?></h3>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this user?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <table class="table table-striped">
        <tr><th>ID</th><td><?= Html::encode($model->id) ?></td></tr>
        <tr><th>Username</th><td><?= Html::encode($model->username) ?></td></tr>
        <tr><th>Role</th><td><?= Html::encode($model->role) ?></td></tr>
        <tr><th>Created</th><td><?= date('Y-m-d H:i:s', $model->created_at) ?></td></tr>
        <tr><th>Updated</th><td><?= date('Y-m-d H:i:s', $model->updated_at) ?></td></tr>
    </table>
</div>
