<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $model app\models\User */
?>
<div class="user-form container">
    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'username')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'password_hash')->passwordInput()->label('Password (leave blank to keep existing)') ?>

    <?php
    // Use passed-in roles list if available, otherwise fallback to defaults
    $roleItems = isset($roles) && is_array($roles) && count($roles) ? $roles : ['admin' => 'Admin', 'user' => 'User'];
    echo $form->field($model, 'role')->dropDownList($roleItems);
    ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>
