<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var app\models\ContactForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\captcha\Captcha;

$this->title = 'Kontak';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-contact">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if (Yii::$app->session->hasFlash('contactFormSubmitted')): ?>

        <div class="alert alert-success">
            Terima kasih telah menghubungi kami. Kami akan merespons secepatnya.
        </div>

        <p>
            Jika debug Yii diaktifkan, Anda dapat melihat pesan email pada panel mail di debugger.
            <?php if (Yii::$app->mailer->useFileTransport): ?>
                Karena aplikasi ini berjalan dalam mode pengembangan, email tidak dikirim tetapi disimpan sebagai
                file di bawah <code><?= Yii::getAlias(Yii::$app->mailer->fileTransportPath) ?></code>.
                Silakan atur properti <code>useFileTransport</code> pada komponen aplikasi <code>mail</code>
                menjadi false untuk mengaktifkan pengiriman email.
            <?php endif; ?>
        </p>

    <?php else: ?>

        <p>
            Jika Anda memiliki pertanyaan bisnis atau lainnya, silakan isi formulir berikut untuk menghubungi kami.
            Terima kasih.
        </p>

        <div class="row">
            <div class="col-lg-5">

                <?php $form = ActiveForm::begin(['id' => 'contact-form']); ?>

                    <?= $form->field($model, 'name')->textInput(['autofocus' => true]) ?>

                    <?= $form->field($model, 'email') ?>

                    <?= $form->field($model, 'subject') ?>

                    <?= $form->field($model, 'body')->textarea(['rows' => 6]) ?>

                    <?= $form->field($model, 'verifyCode')->widget(Captcha::class, [
                        'template' => '<div class="row"><div class="col-lg-3">{image}</div><div class="col-lg-6">{input}</div></div>',
                    ]) ?>

                    <div class="form-group">
                        <?= Html::submitButton('Kirim', ['class' => 'btn btn-primary', 'name' => 'contact-button']) ?>
                    </div>

                <?php ActiveForm::end(); ?>

            </div>
        </div>

    <?php endif; ?>
</div>
