<?php
use yii\helpers\Html;
use yii\grid\GridView;

use yii\widgets\Pjax; // Ensure Pjax import exists
$this->title = 'Pengaturan Pengguna dan Keamanan';
?>
<div class="setting-user container py-3">
    <h3 class="mb-3"><?= Html::encode($this->title) ?></h3>

    <?php if (isset($userProvider) && isset($roleProvider) && isset($permissionProvider)): ?>

        <h4>Manajemen User</h4>
        <p class="text-muted">Tambah, ubah, dan hapus akun pengguna aplikasi.</p>
        <p><?= Html::a('Buat User Baru', ['/user/create'], ['class' => 'btn btn-success mb-2 open-modal', 'data-title' => 'Buat User Baru']) ?></p>
        <?php Pjax::begin(['id' => 'user-grid']); ?>
        <?= GridView::widget([
            'dataProvider' => $userProvider,
            'columns' => [
                ['class' => 'yii\\grid\\SerialColumn'],
                'username',
                'role',
                ['class' => 'yii\\grid\\ActionColumn', 'controller' => 'user', 'header' => 'Aksi',
                    'buttons' => [
                        'view' => function($url, $model, $key) {
                            return Html::a('Lihat', $url, ['class' => 'open-modal', 'data-title' => 'Lihat User', 'data-pjax' => '0']);
                        },
                        'update' => function($url, $model, $key) {
                            return Html::a('Ubah', $url, ['class' => 'open-modal', 'data-title' => 'Ubah User', 'data-pjax' => '0']);
                        },
                        'delete' => function($url, $model, $key) {
                            return Html::a('Hapus', $url, ['data-confirm' => 'Yakin ingin menghapus user ini?', 'data-method' => 'post', 'class' => 'ajax-post text-danger', 'data-pjax' => '0']);
                        }
                    ]
                ],
            ],
        ]) ?>
        <?php Pjax::end(); ?>

        <hr />

        <h4>Manajemen Role</h4>
        <p class="text-muted">Buat dan atur peran serta hak aksesnya.</p>
        <p>
            <?= Html::a('Buat Role Baru', ['/role/create'], ['class' => 'btn btn-secondary mb-2 open-modal', 'data-title' => 'Buat Role Baru']) ?>
        </p>
        <?php Pjax::begin(['id' => 'role-grid']); ?>
        <?= GridView::widget([
            'dataProvider' => $roleProvider,
            'columns' => [
                ['class' => 'yii\\grid\\SerialColumn'],
                'name',
                'description',
                ['class' => 'yii\\grid\\ActionColumn', 'controller' => 'role', 'header' => 'Aksi',
                    'buttons' => [
                        'view' => function($url, $model, $key) {
                            return Html::a('Lihat', $url, ['class' => 'open-modal', 'data-title' => 'Lihat Role', 'data-pjax' => '0']);
                        },
                        'update' => function($url, $model, $key) {
                            return Html::a('Ubah', $url, ['class' => 'open-modal', 'data-title' => 'Ubah Role', 'data-pjax' => '0']);
                        },
                        'delete' => function($url, $model, $key) {
                            return Html::a('Hapus', $url, ['data-confirm' => 'Yakin ingin menghapus role ini?', 'data-method' => 'post', 'class' => 'ajax-post text-danger', 'data-pjax' => '0']);
                        }
                    ]
                ],
            ],
        ]) ?>
        <?php Pjax::end(); ?>

        <hr />

        <h4>Manajemen Permission</h4>
        <p class="text-muted">Kelola permission yang dapat dipetakan ke role.</p>
        <p><?= Html::a('Buat Permission Baru', ['/permission/create'], ['class' => 'btn btn-info mb-2 open-modal', 'data-title' => 'Buat Permission Baru']) ?></p>
        <?php Pjax::begin(['id' => 'permission-grid']); ?>
        <?= GridView::widget([
            'dataProvider' => $permissionProvider,
            'columns' => [
                ['class' => 'yii\\grid\\SerialColumn'],
                'name',
                'description',
                ['class' => 'yii\\grid\\ActionColumn', 'controller' => 'permission', 'header' => 'Aksi',
                    'buttons' => [
                        'view' => function($url, $model, $key) {
                            return Html::a('Lihat', $url, ['class' => 'open-modal', 'data-title' => 'Lihat Permission', 'data-pjax' => '0']);
                        },
                        'update' => function($url, $model, $key) {
                            return Html::a('Ubah', $url, ['class' => 'open-modal', 'data-title' => 'Ubah Permission', 'data-pjax' => '0']);
                        },
                        'delete' => function($url, $model, $key) {
                            return Html::a('Hapus', $url, ['data-confirm' => 'Yakin ingin menghapus permission ini?', 'data-method' => 'post', 'class' => 'ajax-post text-danger', 'data-pjax' => '0']);
                        }
                    ]
                ],
            ],
        ]) ?>
        <?php Pjax::end(); ?>

    <?php else: ?>

        <p>Halaman manajemen user dan peran. Anda memerlukan akses administrator untuk melihat pengaturan ini.</p>
        <div class="row g-3">
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Manajemen User</h5>
                        <p class="card-text">Tambah, ubah, dan hapus akun pengguna aplikasi.</p>
                        <?= Html::a('Buka Manajemen User', ['/user/index'], ['class' => 'btn btn-primary']) ?>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Manajemen Role</h5>
                        <p class="card-text">Buat dan atur peran (role) serta hak aksesnya.</p>
                        <!-- tombol manajemen role dihilangkan sesuai permintaan -->
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Manajemen Permission</h5>
                        <p class="card-text">Kelola permission yang dapat dipetakan ke role.</p>
                        <!-- tombol manajemen permission dihilangkan sesuai permintaan -->
                    </div>
                </div>
            </div>
        </div>

    <?php endif; ?>

</div>

<!-- Modal for quick-create forms -->
<div class="modal fade" id="quickModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">&nbsp;</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">Loading…</div>
        </div>
    </div>
</div>

<?php $this->registerJs(<<<'JS'
    $(function(){
    // open link target in modal
    $(document).on('click', 'a.open-modal', function(e){
        e.preventDefault();
        var url = $(this).attr('href');
        var title = $(this).data('title') || '';
        var $m = $('#quickModal');
        $m.find('.modal-title').text(title);
        $m.find('.modal-body').html('Memuat...');
        $m.modal('show');
        $.get(url, function(html){
            $m.find('.modal-body').html(html);
        });
    });

    // intercept form submit inside modal for AJAX
    $(document).on('submit', '#quickModal form', function(e){
        e.preventDefault();
        var $form = $(this);
        var $m = $('#quickModal');
        $.ajax({
            url: $form.attr('action'),
            method: $form.attr('method') || 'POST',
            data: $form.serialize(),
        }).done(function(resp){
            // server may return JSON (success) or HTML (rendered form with errors)
            if (typeof resp === 'object' && resp.success) {
                // close modal and reload relevant grids via PJAX
                $m.modal('hide');
                $.pjax.reload({container: '#user-grid'});
                $.pjax.reload({container: '#role-grid'});
                $.pjax.reload({container: '#permission-grid'});
            } else if (typeof resp === 'string') {
                // HTML - replace modal body (contains validation messages)
                $m.find('.modal-body').html(resp);
            } else {
                alert('Terjadi kesalahan pada respons server.');
            }
        }).fail(function(){
            alert('Gagal mengirim data.');
        });
    });

    // handle ajax-post delete links inside grids
    $(document).on('click', 'a.ajax-post', function(e){
        e.preventDefault();
        var $a = $(this);
        if (!confirm($a.data('confirm') || 'Yakin?')) return;
        var url = $a.attr('href');
        $.post(url).done(function(resp){
            if (resp && resp.success) {
                $.pjax.reload({container: '#user-grid'});
                $.pjax.reload({container: '#role-grid'});
                $.pjax.reload({container: '#permission-grid'});
                if (resp.message) alert(resp.message);
            } else if (resp && resp.message) {
                alert(resp.message);
            } else {
                alert('Operasi gagal.');
            }
        }).fail(function(){
            alert('Gagal menghapus data.');
        });
    });
});
JS
);
