<?php
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $prefixBarang string */
/* @var $prefixPelanggan string */
/* @var $prefixPayment string */
/* @var $prefixKontrak string */

$this->title = 'Pengaturan Kode Prefix';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="setting-prefix container">
    <h3><?= Html::encode($this->title) ?></h3>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success"><?= Html::encode(Yii::$app->session->getFlash('success')) ?></div>
    <?php endif; ?>

    <form method="post" action="<?= Url::to(['setting/save']) ?>">
        <?= Html::hiddenInput(Yii::$app->request->csrfParam, Yii::$app->request->getCsrfToken()) ?>
        <div class="mb-3">
            <label class="form-label">Prefix Kode Barang</label>
            <input type="text" class="form-control" name="prefix_barang" value="<?= Html::encode($prefixBarang) ?>">
            <div class="form-text">Contoh: BRG-</div>
        </div>
        <div class="mb-3">
            <label class="form-label">Prefix Kode Pelanggan</label>
            <input type="text" class="form-control" name="prefix_pelanggan" value="<?= Html::encode($prefixPelanggan) ?>">
            <div class="form-text">Contoh: PLG-</div>
        </div>
        <div class="mb-3">
            <label class="form-label">Prefix Kode Pembayaran</label>
            <input type="text" class="form-control" name="prefix_payment" value="<?= Html::encode($prefixPayment ?? 'PAY-') ?>">
            <div class="form-text">Contoh: PAY- (kode akan menjadi PAY-YYYYMMDD-0001)</div>
        </div>
        <div class="mb-3">
            <label class="form-label">Prefix Kode Kontrak</label>
            <input type="text" class="form-control" name="prefix_kontrak" value="<?= Html::encode($prefixKontrak ?? 'KTR-') ?>">
            <div class="form-text">Contoh: KTR- (kode akan menjadi KTR-YYMMDD-0001)</div>
        </div>
        <div class="mb-3">
            <button class="btn btn-primary" type="submit">Simpan</button>
            <?= Html::a('Regenerate Semua Kode', ['setting/regenerate'], ['class' => 'btn btn-outline-danger', 'data-method' => 'post', 'style' => 'margin-left:8px']) ?>
        </div>
    </form>

</div>
