<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Pengaturan Logo';
?>
<div class="setting-logo container">
    <h3><?= Html::encode($this->title) ?></h3>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success"><?= Html::encode(Yii::$app->session->getFlash('success')) ?></div>
    <?php endif; ?>
    <?php if (Yii::$app->session->hasFlash('error')): ?>
        <div class="alert alert-danger"><?= Html::encode(Yii::$app->session->getFlash('error')) ?></div>
    <?php endif; ?>

    <div class="mb-3">
        <strong>Logo saat ini:</strong>
        <?php $logoPath = Yii::getAlias('@web') . '/uploads/logo.png';
        $logoFs = Yii::getAlias('@webroot') . DIRECTORY_SEPARATOR . 'uploads' . DIRECTORY_SEPARATOR . 'logo.png';
        if (file_exists($logoFs)): ?>
            <div class="mt-2"><img src="<?= Html::encode($logoPath) ?>" style="height:80px;" alt="logo" /></div>
        <?php else: ?>
            <div class="mt-2 text-muted">Belum ada logo diunggah.</div>
        <?php endif; ?>
    </div>

    <?php $form = ActiveForm::begin(['options'=>['enctype'=>'multipart/form-data']]); ?>
        <?= $form->field($model, 'imageFile')->fileInput() ?>
        <div class="form-group">
            <?= Html::submitButton('Unggah', ['class'=>'btn btn-primary']) ?>
        </div>
    <?php ActiveForm::end(); ?>
</div>
