<?php
use yii\helpers\Html;

$this->title = 'Role: ' . $model->name;
?>
<div class="role-view container">
    <h3><?= Html::encode($this->title) ?></h3>
    <p>
        <?= Html::a('Update', ['role/update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['role/delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => ['confirm' => 'Are you sure?', 'method' => 'post'],
        ]) ?>
    </p>

    <table class="table table-striped">
        <tr><th>ID</th><td><?= Html::encode($model->id) ?></td></tr>
        <tr><th>Name</th><td><?= Html::encode($model->name) ?></td></tr>
        <tr><th>Description</th><td><?= Html::encode($model->description) ?></td></tr>
        <tr><th>Permissions</th>
            <td>
                <?php foreach ($model->permissions as $perm): ?>
                    <span class="badge bg-secondary"><?= Html::encode($perm->name) ?></span>
                <?php endforeach; ?>
            </td>
        </tr>
    </table>
</div>
