<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $model app\models\Role */
?>
<div class="role-form container">
    <?php $form = ActiveForm::begin(); ?>

        <?= $form->field($model, 'name')->textInput(['maxlength' => true])->label('Nama Role') ?>
        <?= $form->field($model, 'description')->textInput(['maxlength' => true])->label('Deskripsi') ?>

        <?php
        // permission matrix UI
        $menus = [
            'barang' => 'Barang',
            'pelanggan' => 'Pelanggan',
            'kontrak' => 'Kontrak',
            'pembayaran' => 'Pembayaran',
            'pengaturan' => 'Pengaturan',
        ];
        $actions = [
            'view' => 'Lihat',
            'create' => 'Tambah',
            'update' => 'Ubah',
            'delete' => 'Hapus',
            'print' => 'Cetak',
            'approve' => 'Approve',
        ];

        // current permissions as names (menu.action)
        $currentNames = [];
        if (!$model->isNewRecord) {
            foreach ($model->getPermissions()->all() as $p) $currentNames[] = $p->name;
        }
        ?>

        <h5>Hak Akses (klik untuk mengizinkan)</h5>
        <div class="mb-2">
            <button type="button" class="btn btn-sm btn-primary btn-check-all">Centang Semua</button>
            <button type="button" class="btn btn-sm btn-secondary btn-uncheck-all">Buang Centang Semua</button>
        </div>
        <div class="table-responsive">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Menu</th>
                    <?php foreach ($actions as $aLabel): ?>
                        <th class="text-center"><?= Html::encode($aLabel) ?></th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($menus as $mKey => $mLabel): ?>
                <tr>
                    <td><?= Html::encode($mLabel) ?></td>
                    <?php foreach ($actions as $aKey => $aLabel):
                        $permName = $mKey . '.' . $aKey;
                        $checked = in_array($permName, $currentNames);
                    ?>
                        <td class="text-center">
                            <input type="checkbox" name="matrix[<?= Html::encode($mKey) ?>][<?= Html::encode($aKey) ?>]" value="1" <?= $checked ? 'checked' : '' ?> />
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        </div>

        <div class="form-group">
            <?= Html::submitButton('Simpan', ['class' => 'btn btn-success']) ?>
        </div>

    <?php ActiveForm::end(); ?>
    <script>
    (function($){
        // global handlers so they work inside PJAX/modal
        $(document).on('click', '.btn-check-all', function(e){
            var $form = $(this).closest('.role-form');
            $form.find('input[type=checkbox]').prop('checked', true);
        });
        $(document).on('click', '.btn-uncheck-all', function(e){
            var $form = $(this).closest('.role-form');
            $form.find('input[type=checkbox]').prop('checked', false);
        });
    })(jQuery);
    </script>
</div>
