<?php
use yii\helpers\Html;
use yii\helpers\Url;
/* @var $this \yii\web\View */
/* @var $model app\models\Pembayaran */

?>
<div class="pembayaran-view">
    <?php
        $kontrak = $model->kontrak ?? null;
        $pelangganName = $model->pelanggan ? ($model->pelanggan->nama ?? $model->pelanggan_id) : $model->pelanggan_id;
        // build installment map and ordered list for nicer display / allocation
            $installmentsMap = [];
            $installmentsOrdered = [];
            if ($kontrak && $kontrak->installments) {
                foreach ($kontrak->installments as $ins) {
                    $installmentsMap[$ins->id] = $ins;
                    $installmentsOrdered[] = $ins;
                }
            }
    ?>

    <style>
    .pembayaran-view table { border-collapse: collapse; width: 100%; }
    .pembayaran-view th, .pembayaran-view td { border: 1px solid #ddd; padding: 8px; }
    .pembayaran-view th { background: #f8f9fa; text-align: left; }

    /* Thermal 80mm print layout */
    @page { size: 80mm auto; margin: 4mm; }
    .receipt {
        width: 80mm;
        max-width: 80mm;
        font-family: "Courier New", Courier, monospace;
        font-size: 12px;
        color: #000;
    }
    @media print {
        body { background: #fff; }
        /* hide everything except the receipt container */
        body * { visibility: hidden; }
        .receipt, .receipt * { visibility: visible; }
        .receipt { position: absolute; left: 0; top: 0; }
        /* compact table style for thermal printing */
        .receipt table { width: 100%; border-collapse: collapse; font-size: 12px; }
        .receipt th, .receipt td { border: none; padding: 2px 0; }
        .no-print { display: none !important; }
    }
    </style>

    <div class="receipt">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0">Detail Pembayaran: <?= Html::encode($model->nomor) ?></h4>
        <div>
            <?= Html::a('Kembali', '#', ['class'=>'btn btn-secondary btn-sm me-2 no-print', 'onclick'=>'history.back(); return false;']) ?>
            <button class="btn btn-outline-primary btn-sm no-print" onclick="window.print()">Cetak</button>
        </div>
    </div>

    <p>
        <strong>Pelanggan:</strong> <?= Html::encode($pelangganName) ?><br />
        <strong>Kontrak:</strong>
        <?php if ($kontrak && !empty($kontrak->nomor)): ?>
            <?php $histUrl = Url::to(['pembayaran/history','kontrak_id'=>$kontrak->id]); ?>
            <?= Html::a(Html::encode($kontrak->nomor), $histUrl) ?>
        <?php else: ?>
            <?= Html::encode($model->kontrak_id) ?>
        <?php endif; ?>
        <br />
        <strong>Total Bayar:</strong> <?= Yii::$app->formatter->asCurrency($model->total_bayar) ?><br />
        <strong>Dibuat:</strong> <?php
            try { $dt = new \DateTime($model->created_at); $dt->setTimezone(new \DateTimeZone(Yii::$app->timeZone)); echo Yii::$app->formatter->asDate($dt,'medium') . ' ' . $dt->format('H:i'); }
            catch (\Exception $e) { echo Html::encode($model->created_at); }
        ?>
    </p>

    <h5>Item Pembayaran</h5>
    <?php $items = is_array($model->items) ? $model->items : (method_exists($model->items,'all') ? $model->items->all() : (array)$model->items); ?>
    <?php if (!empty($items)): ?>
        <?php
            // expand items into display rows, allocating unassigned amounts across installments
            $rows = [];
            // prepare paid totals per installment from database (includes current pembayaran)
            $installmentIds = [];
            foreach ($installmentsOrdered as $ins) $installmentIds[] = $ins->id;
            $paidTotals = [];
            if (!empty($installmentIds)) {
                $paidRows = (new \yii\db\Query())
                    ->select(['kontrak_installment_id','SUM(amount) AS total'])
                    ->from('pembayaran_item')
                    ->where(['kontrak_installment_id' => $installmentIds])
                    ->andWhere(['<>','pembayaran_id', $model->id])
                    ->groupBy('kontrak_installment_id')
                    ->all();
                foreach ($paidRows as $pr) $paidTotals[$pr['kontrak_installment_id']] = floatval($pr['total']);
            }

            // Build aggregated allocation of this pembayaran's items per installment
            // 1) separate explicit items (linked to installment) and orphan items (no instal id)
            $explicitThis = [];
            $orphanTotalThis = 0;
            foreach ($items as $it) {
                if ($it->kontrak_installment_id !== null) {
                    $id = $it->kontrak_installment_id;
                    $explicitThis[$id] = ($explicitThis[$id] ?? 0) + (float)$it->amount;
                } else {
                    $orphanTotalThis += (float)$it->amount;
                }
            }

            // 2) allocate orphanTotalThis across installments, respecting existing payments (paidTotals computed earlier)
            $allocatedThis = [];
            $remainingOrphan = $orphanTotalThis;
            foreach ($installmentsOrdered as $ins) {
                if ($remainingOrphan <= 0) break;
                $due = (float)$ins->amount;
                $alreadyPaid = $paidTotals[$ins->id] ?? 0; // payments from other receipts
                $explicitPaidHere = $explicitThis[$ins->id] ?? 0; // explicit part in this receipt
                $remainingDue = max(0, $due - $alreadyPaid - $explicitPaidHere);
                if ($remainingDue <= 0) continue;
                $alloc = min($remainingOrphan, $remainingDue);
                if ($alloc > 0) {
                    $allocatedThis[$ins->id] = ($allocatedThis[$ins->id] ?? 0) + $alloc;
                    $remainingOrphan -= $alloc;
                }
            }

            // 3) build rows: one row per installment that received an amount in this pembayaran
            foreach ($installmentsOrdered as $ins) {
                $amt = ($explicitThis[$ins->id] ?? 0) + ($allocatedThis[$ins->id] ?? 0);
                if ($amt <= 0) continue;
                $rows[] = [
                    'periode' => $ins->periode,
                    'due_date' => $ins->due_date ?: null,
                    'amount' => $amt,
                    'note' => '',
                    'original' => ($explicitThis[$ins->id] ?? 0) > 0 ? ($explicitThis[$ins->id] + ($allocatedThis[$ins->id] ?? 0)) : ($allocatedThis[$ins->id] ?? 0),
                ];
            }

            // 4) if any orphan leftover (couldn't be allocated), show as Unallocated row
            if ($remainingOrphan > 0) {
                $rows[] = [
                    'periode' => 'Unallocated',
                    'due_date' => null,
                    'amount' => $remainingOrphan,
                    'note' => 'Kelebihan bayar',
                    'original' => $remainingOrphan,
                ];
            }
        ?>
        <table>
            <thead>
                <tr>
                    <th>Periode</th>
                    <th>Jatuh Tempo</th>
                    <th>Jumlah</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($rows as $row): ?>
                <tr>
                    <td><?= Html::encode($row['periode']) ?></td>
                    <td><?= $row['due_date'] ? Yii::$app->formatter->asDate($row['due_date'],'medium') : '-' ?></td>
                    <td>
                        <?= Yii::$app->formatter->asCurrency($row['amount']) ?>
                        <?php if ($row['original'] > $row['amount']): ?>
                            <br /><small>(dari <?= Yii::$app->formatter->asCurrency($row['original']) ?>)</small>
                        <?php endif; ?>
                    </td>
                    
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Tidak ada item pembayaran.</p>
    <?php endif; ?>
    </div> <!-- /.receipt -->
</div>
