<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\LinkPager;
/* @var $models array */
/* @var $pagination \yii\data\Pagination */
/* @var $q string */
/* @var $from string */
/* @var $to string */
?>
<?php
// register flatpickr (CDN) for nicer datepickers
$this->registerCssFile('https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css', ['depends'=>\yii\web\JqueryAsset::class]);
$this->registerJsFile('https://cdn.jsdelivr.net/npm/flatpickr', ['depends'=>\yii\web\JqueryAsset::class]);
$this->registerJs(<<<'JS'
flatpickr('input[name="from"]',{dateFormat:'Y-m-d',allowInput:true});
flatpickr('input[name="to"]',{dateFormat:'Y-m-d',allowInput:true});
JS
, \yii\web\View::POS_READY);
?>
<div class="container">
    <h3>Daftar Pembayaran</h3>
    <p><a class="btn btn-primary" href="<?= Url::to(['pembayaran/create'])?>">Buat Pembayaran Baru</a></p>

    <form id="pembayaran-filter-form" method="get" action="<?= Url::to(['pembayaran/index'])?>" class="row g-3 mb-3 align-items-end">
        <div class="col-md-4">
            <label class="form-label">Cari</label>
            <input type="text" name="q" class="form-control" placeholder="Cari nomor / nama / no WA / nomor kontrak" value="<?= Html::encode($q ?? '') ?>">
        </div>
        <div class="col-md-2">
            <label class="form-label">Dari</label>
            <input type="date" name="from" class="form-control" value="<?= Html::encode($from ?? '') ?>">
        </div>
        <div class="col-md-2">
            <label class="form-label">Sampai</label>
            <input type="date" name="to" class="form-control" value="<?= Html::encode($to ?? '') ?>">
        </div>
        <div class="col-md-2 d-flex">
            <button class="btn btn-secondary me-2" type="submit">Filter</button>
            <a class="btn btn-link align-self-start" href="<?= Url::to(['pembayaran/index'])?>">Reset</a>
        </div>
    </form>

    <div id="pembayaran-list-container">
        <?= $this->render('_list', ['models'=>$models,'pagination'=>$pagination]) ?>
    </div>
</div>

<div id="pembayaran-list-loading" class="text-center my-2 d-none">
    <div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div>
</div>

<?php
// ensure filter form works reliably: build URL on submit (avoids issues with base URL or unexpected form behavior)
$ajaxUrl = Url::to(['pembayaran/index'], true);
$js = "var AJAX_INDEX_URL = " . json_encode($ajaxUrl) . ";\n";
$js .= <<<'JS'
$('#pembayaran-filter-form').on('submit', function(e){
    e.preventDefault();
    var q = $('input[name="q"]', this).val()||'';
    var from = $('input[name="from"]', this).val()||'';
    var to = $('input[name="to"]', this).val()||'';
    var params = {};
    if (q) params.q = q;
    if (from) params.from = from;
    if (to) params.to = to;
    console.log('Pembayaran filter submit', params);
    var $spinner = $('#pembayaran-list-loading');
    $spinner.removeClass('d-none');
    $.ajax({
        url: AJAX_INDEX_URL,
        method: 'GET',
        data: params,
        timeout: 10000,
        success: function(html){
            console.log('Pembayaran filter success, replacing list');
            $('#pembayaran-list-container').html(html);
        },
        error: function(xhr, status, err){
            console.error('Pembayaran filter AJAX error', status, err);
            var fallback = AJAX_INDEX_URL;
            var query = $.param(params);
            if (query) fallback += '?' + query;
            console.log('Falling back to', fallback);
            window.location.href = fallback;
        },
        complete: function(){
            $spinner.addClass('d-none');
        }
    });
});
// also support clicking pagination links by ajax (with logging/fallback)
$(document).on('click', '#pembayaran-list-container .pagination a', function(e){
    e.preventDefault();
    var href = $(this).attr('href');
    console.log('Pembayaran pagination click', href);
    var $spinner = $('#pembayaran-list-loading');
    $spinner.removeClass('d-none');
    $.ajax({
        url: href,
        method: 'GET',
        timeout: 10000,
        success: function(html){
            console.log('Pembayaran pagination success');
            $('#pembayaran-list-container').html(html);
        },
        error: function(xhr, status, err){
            console.error('Pembayaran pagination AJAX error', status, err);
            window.location.href = href;
        },
        complete: function(){ $spinner.addClass('d-none'); }
    });
});
JS;

$this->registerJs($js, \yii\web\View::POS_READY);
?>
