<?php
use yii\helpers\Html;
use yii\helpers\Url;

/** @var $this \yii\web\View */
/** @var $models app\models\Pembayaran[] */
/** @var $kontrak_id int */

$this->title = 'History Transaksi Kontrak ' . Html::encode($kontrak_id);
?>
<div class="container">
    <h3><?= Html::encode($this->title) ?></h3>
    <p><?= Html::button('Kembali', ['class'=>'btn btn-secondary','onclick'=>'history.back()']) ?></p>

    <?php if (empty($models)): ?>
        <div class="alert alert-info">Belum ada pembayaran untuk kontrak ini.</div>
    <?php else: ?>
        <?php
            // Use the kontrak from the first pembayaran (all rows are same kontrak)
            $first = reset($models);
            $kontrak = $first->kontrak;
            $kontrakNomor = $kontrak ? $kontrak->nomor : '-';
            $pelangganName = $kontrak && $kontrak->pelanggan ? $kontrak->pelanggan->nama : ($first->pelanggan_id ?? '-');
            $tglMulai = $kontrak && $kontrak->tanggal_mulai ? Yii::$app->formatter->asDate($kontrak->tanggal_mulai,'long') : '-';
            if (!isset($installments)) {
                $installments = $kontrak ? $kontrak->installments : [];
            }
            $tglSelesai = '-';
            if ($installments) {
                $last = end($installments);
                $tglSelesai = $last->due_date ? Yii::$app->formatter->asDate($last->due_date,'long') : '-';
            }
            $totalHutang = ($kontrak && isset($kontrak->total_harga)) ? floatval($kontrak->total_harga) : 0;
            $totalPaidAll = (new \yii\db\Query())->from('pembayaran')->where(['kontrak_id' => $kontrak ? $kontrak->id : $first->kontrak_id])->sum('total_bayar') ?: 0;
            $sisaHutang = $totalHutang - $totalPaidAll;
            $tagihanCount = is_array($installments) ? count($installments) : (method_exists($installments,'count') ? $installments->count() : 0);
            $lastPembayaranNomor = $models[0]->nomor ?? '-';
        ?>

        <div class="card mb-3">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <strong>Nomor Kontrak:</strong> <?= Html::encode($kontrakNomor) ?>
                        <div class="mt-2"><strong>Nama:</strong> <?= Html::encode($pelangganName) ?></div>
                    </div>
                    <div class="col-md-4">
                        <strong>Nomor Pembayaran (terakhir):</strong> <?= Html::encode($lastPembayaranNomor) ?>
                        <?php if (!empty($models[0])): ?>
                            <?= Html::a('Hapus', ['pembayaran/delete','id'=>$models[0]->id], ['class'=>'btn btn-sm btn-outline-danger ms-2','data'=>['method'=>'post','confirm'=>'Hapus pembayaran terakhir ini?']]) ?>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-4">
                        <div><strong>Tgl Mulai:</strong> <?= $tglMulai ?></div>
                        <div class="mt-2"><strong>Tgl Selesai:</strong> <?= $tglSelesai ?></div>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-4"><strong>Total Hutang:</strong> <?= Yii::$app->formatter->asCurrency($totalHutang) ?></div>
                    <div class="col-md-4"><strong>Sisa Hutang:</strong> <?= Yii::$app->formatter->asCurrency($sisaHutang) ?></div>
                    <div class="col-md-4"><strong>Tagihan:</strong> <?= $tagihanCount ?></div>
                </div>
            </div>
        </div>

        <table class="table table-bordered table-sm">
            <thead>
                <tr>
                    <th>Periode Cicilan</th>
                    <th>Tanggal Jatuh Tempo</th>
                    <th>Besar Cicilan</th>
                    <th>Dibayar pada</th>
                    <th>Jumlah Dibayar</th>
                    <th>Status</th>
                    <th>Keterangan</th>
                </tr>
            </thead>
            <tbody>
            <?php if (empty($installments)): ?>
                <tr><td colspan="7" class="text-center">Tidak ada jadwal cicilan</td></tr>
            <?php else: ?>
                <?php
                    $today = (new \DateTime('now', new \DateTimeZone(Yii::$app->timeZone)))->format('Y-m-d');
                ?>
                <?php foreach ($installments as $ins): ?>
                    <?php
                        // Use preloaded items if provided by the controller to avoid per-installment queries
                        if (isset($itemsByInstallment) && isset($itemsByInstallment[$ins->id])) {
                            $paidRows = $itemsByInstallment[$ins->id];
                        } else {
                            $paidRows = (new \yii\db\Query())->from('pembayaran_item')->where(['kontrak_installment_id' => $ins->id])->orderBy(['paid_at' => SORT_ASC])->all();
                        }
                        $paidAmt = 0;
                        $paidEntries = []; // each entry: ['paid_at'=>..., 'amount'=>..., 'pembayaran_id'=>..., 'pembayaran_nomor'=>...]
                        foreach ($paidRows as $pr) {
                            $paidAmt += floatval($pr['amount']);
                            $paidAtObj = null;
                            // prefer explicit paid_at when it's a valid non-zero timestamp
                            if (!empty($pr['paid_at']) && strpos($pr['paid_at'],'0000-00-00') === false) {
                                try {
                                    $tmp = new \DateTime($pr['paid_at']);
                                    $tmp->setTimezone(new \DateTimeZone(Yii::$app->timeZone));
                                    $year = (int)$tmp->format('Y');
                                    if ($year > 1970) {
                                        $paidAtObj = $tmp;
                                    }
                                } catch (\Exception $e) { $paidAtObj = null; }
                            }
                            if ($paidAtObj === null) {
                                $pbCreated = $pembayaranCreatedMap[$pr['pembayaran_id']] ?? null;
                                if (!empty($pbCreated)) {
                                    try {
                                        $tmp2 = new \DateTime($pbCreated);
                                        $tmp2->setTimezone(new \DateTimeZone(Yii::$app->timeZone));
                                        $paidAtObj = $tmp2;
                                    } catch (\Exception $e) { $paidAtObj = null; }
                                }
                            }
                            $paidEntries[] = [
                                'paid_at' => $paidAtObj,
                                'amount' => floatval($pr['amount']),
                                'pembayaran_id' => $pr['pembayaran_id'] ?? null,
                                'pembayaran_nomor' => ($pembayaranNomorMap[$pr['pembayaran_id']] ?? null),
                            ];
                        }
                        $status = 'Belum Lunas';
                        if ($paidAmt >= floatval($ins->amount)) $status = 'Lunas';
                        elseif ($paidAmt > 0) $status = 'Sebagian';

                        // keterangan
                        $keterangan = '-';
                        if (!empty($paidDates)) {
                            $firstPaid = new \DateTime($paidDates[0]);
                            $due = new \DateTime($ins->due_date);
                            $diff = (int)($firstPaid->getTimestamp() - $due->getTimestamp());
                            $days = (int)floor($diff / 86400);
                            if ($firstPaid < $due) {
                                $keterangan = 'Cepat bayar';
                            } elseif ($days <= 3) {
                                $keterangan = 'Tepat Waktu';
                            } else {
                                $keterangan = 'Terlambat';
                            }
                        }
                    ?>
                    <tr>
                        <td><?= Html::encode($ins->periode) ?></td>
                        <td><?= $ins->due_date ? Yii::$app->formatter->asDate($ins->due_date,'medium') : '-' ?></td>
                        <td><?= Yii::$app->formatter->asCurrency($ins->amount) ?></td>
                        <td>
                            <?php if (empty($paidEntries)): ?>
                                -
                            <?php else: ?>
                                <?php foreach ($paidEntries as $entry): ?>
                                    <?php
                                        $dt = null;
                                        if (!empty($entry['paid_at'])) {
                                            if ($entry['paid_at'] instanceof \DateTime) {
                                                $dt = $entry['paid_at'];
                                                try { $dt->setTimezone(new \DateTimeZone(Yii::$app->timeZone)); } catch (\Exception $e) {}
                                            } else {
                                                try {
                                                    $dt = new \DateTime($entry['paid_at']);
                                                    $dt->setTimezone(new \DateTimeZone(Yii::$app->timeZone));
                                                } catch (\Exception $e) { $dt = null; }
                                            }
                                        }
                                    ?>
                                    <div>
                                        <?= $dt ? (Yii::$app->formatter->asDate($dt,'medium') . ' ' . $dt->format('H:i')) : '-' ?>
                                        &nbsp;&mdash;&nbsp;<strong><?= Yii::$app->formatter->asCurrency($entry['amount']) ?></strong>
                                        <?php
                                            $origTotal = $entry['pembayaran_id'] ? ($pembayaranTotalMap[$entry['pembayaran_id']] ?? null) : null;
                                        ?>
                                        <?php if (!empty($origTotal) && floatval($origTotal) != floatval($entry['amount'])): ?>
                                            &nbsp;<small>(dari <?= Yii::$app->formatter->asCurrency($origTotal) ?>)</small>
                                        <?php endif; ?>
                                        <?php if (!empty($entry['pembayaran_nomor'])): ?>
                                            &nbsp;<small>(<?= Html::a(Html::encode($entry['pembayaran_nomor']), ['pembayaran/view','id'=>$entry['pembayaran_id']]) ?>)</small>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </td>
                        <td><?= Yii::$app->formatter->asCurrency($paidAmt) ?></td>
                        <td><?= $status ?></td>
                        <td><?= Html::encode($keterangan) ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
