<?php
use yii\helpers\Url;
use yii\helpers\Html;
/* simple pembayaran create form */
?>
<div class="container">
    <h3>Buat Pembayaran</h3>

    <div class="mb-3">
        <label class="form-label">Pelanggan</label>
        <select id="pemb-pelanggan" class="form-select"></select>
    </div>

    <div class="mb-3">
        <label class="form-label">Pilih Kontrak</label>
        <select id="pemb-kontrak" class="form-select"><option value="">Pilih pelanggan terlebih dahulu</option></select>
    </div>

    <div id="pemb-installments" class="mb-3"></div>

    <div class="mb-3">
        <label class="form-label">Nominal Pembayaran (Rp)</label>
        <input id="pemb-amount" class="form-control" type="text" placeholder="0">
    </div>

    <div class="mb-3">
        <button id="pemb-save" class="btn btn-primary">Simpan Pembayaran</button>
        <a class="btn btn-link" href="<?= Url::to(['pembayaran/index'])?>">Batal</a>
    </div>
</div>

<?php
// Build absolute URLs for use inside JS (to avoid PHP tags inside JS nowdoc)
$urlSearch = Url::to(['pembayaran/search-pelanggan'], true);
$urlKontrak = Url::to(['pembayaran/kontrak-for-pelanggan'], true);
$urlInstall = Url::to(['pembayaran/get-installments'], true);
$urlCreate = Url::to(['pembayaran/create'], true);
$urlPrint = Url::to(['pembayaran/print'], true);
$urlIndex = Url::to(['pembayaran/index'], true);

$this->registerCssFile('@web/vendor/select2/select2.min.css', ['depends'=>\yii\web\JqueryAsset::class]);
$this->registerJsFile('@web/vendor/select2/select2.min.js', ['depends'=>\yii\web\JqueryAsset::class]);

$js = "const URL_SEARCH_PEL = " . json_encode($urlSearch) . ";\n";
$js .= "const URL_GET_KONTRAK = " . json_encode($urlKontrak) . ";\n";
$js .= "const URL_GET_INSTALLMENTS = " . json_encode($urlInstall) . ";\n";
$js .= "const URL_CREATE = " . json_encode($urlCreate) . ";\n";
$js .= "const URL_PRINT = " . json_encode($urlPrint) . ";\n";
$js .= "const URL_INDEX = " . json_encode($urlIndex) . ";\n";
$js .= <<<'JS'
// init select2 for pelanggan
$('#pemb-pelanggan').select2({
    placeholder: 'Cari pelanggan (nama / no ktp / no WA)',
    ajax: {
        url: URL_SEARCH_PEL,
        dataType: 'json',
        delay: 250,
        data: function(params){ return {q: params.term}; },
        processResults: function(data){ return {results: data.results}; }
    }
});

// helper: format local datetime as Indonesian 'DD/MM/YYYY HH:MM:SS'
function formatLocalDatetime(d) {
    function pad(n){ return n < 10 ? '0' + n : n; }
    var day = pad(d.getDate());
    var month = pad(d.getMonth()+1);
    var year = d.getFullYear();
    var hh = pad(d.getHours());
    var mm = pad(d.getMinutes());
    var ss = pad(d.getSeconds());
    return day + '/' + month + '/' + year + ' ' + hh + ':' + mm + ':' + ss;
}

$('#pemb-pelanggan').on('select2:select', function(e){
    var id = e.params.data.id;
    var $k = $('#pemb-kontrak');
    $k.empty().append($('<option/>',{value:'' , text: 'Pilih kontrak'}));
    $.get(URL_GET_KONTRAK, {pelanggan_id: id}, function(data){
        if (!Array.isArray(data)) {
            console.error('Kontrak list not array', data);
            return;
        }
        data.forEach(function(r){ $k.append($('<option/>',{value:r.id,text:r.text})); });
    }, 'json');
});

$('#pemb-kontrak').on('change', function(){
    var id = $(this).val();
    if (!id) { $('#pemb-installments').html(''); return; }
    $.get(URL_GET_INSTALLMENTS, {kontrak_id:id}, function(rows){
        if (!rows) { $('#pemb-installments').html('<div class="text-danger">Gagal memuat cicilan.</div>'); return; }
        if (rows.error) {
            console.error('GetInstallments error', rows.message || rows);
            $('#pemb-installments').html('<div class="text-danger">Gagal memuat cicilan: '+(rows.message||'Unknown error')+'</div>');
            return;
        }
        if (!Array.isArray(rows)) {
            console.error('GetInstallments unexpected response', rows);
            $('#pemb-installments').html('<div class="text-danger">Respons cicilan tidak valid.</div>');
            return;
        }
        var html = '<div class="table-responsive"><table class="table table-sm"><thead><tr><th>Periode</th><th>Jatuh Tempo</th><th>Besar Cicilan</th><th>Tanggal Dibayar</th><th>Jumlah Dibayar</th><th>Status</th><th>Keterangan</th><th>Pilih</th></tr></thead><tbody>';
                rows.forEach(function(r){
            var status = r.paid >= r.amount ? 'Lunas' : (r.paid>0 ? 'Sebagian' : 'Belum Lunas');
            // due_date comes pre-formatted from server as Indonesian date
            var dueDate = r.due_date || r.due_date_raw || '';
            var paidAt = r.paid_at ? r.paid_at : '';
            var keterangan = r.keterangan ? r.keterangan : '';
            html += '<tr data-id="'+r.id+'">'
                + '<td>'+r.periode+'</td>'
                + '<td>'+dueDate+'</td>'
                + '<td>Rp '+(Number(r.amount).toLocaleString('id-ID'))+'</td>'
                + '<td>'+paidAt+'</td>'
                + '<td>Rp '+(Number(r.paid).toLocaleString('id-ID'))+'</td>'
                + '<td>'+status+'</td>'
                + '<td>'+keterangan+'</td>'
                + '<td><input type="checkbox" class="pemb-select" data-amt="'+r.amount+'" data-paid="'+r.paid+'"></td>'
                + '</tr>';
        });
        html += '</tbody></table></div>';
        $('#pemb-installments').html(html);
        // reset input when new installments loaded
        $('#pemb-amount').val('0');
    }, 'json');
});

// compute sum of selected installments (amount - paid) and populate input
function computeSelectedSum(){
    var sum = 0;
    $('#pemb-installments').find('.pemb-select:checked').each(function(){
        var amt = Number($(this).data('amt')) || 0;
        var paid = Number($(this).data('paid')) || 0;
        var due = amt - paid;
        if (due > 0) sum += due;
    });
    // format with Indonesian thousand separator, keep plain 0 when sum is zero
    $('#pemb-amount').val(sum > 0 ? sum.toLocaleString('id-ID') : '0');
}

// delegated handler (attach once) that enforces sequential selection
$(document).off('change', '#pemb-installments .pemb-select').on('change', '#pemb-installments .pemb-select', function(){
    var $checks = $('#pemb-installments').find('.pemb-select');
    var idx = $checks.index(this);
    if ($(this).is(':checked')) {
        $checks.each(function(i){ if (i <= idx) $(this).prop('checked', true); });
    } else {
        $checks.each(function(i){ if (i > idx) $(this).prop('checked', false); });
    }
    computeSelectedSum();
});

// visual formatting while typing: thousand separators (id-ID)
$('#pemb-amount').on('input', function(){
    var raw = $(this).val().toString().replace(/\D/g,'');
    if (raw === '') { $(this).val('0'); return; }
    // avoid leading zeros parse issue
    var n = parseInt(raw, 10) || 0;
    $(this).val(n.toLocaleString('id-ID'));
});

$('#pemb-save').on('click', function(e){
    e.preventDefault();
    var pelanggan = $('#pemb-pelanggan').val();
    var kontrak = $('#pemb-kontrak').val();
    // remove non-digits (thousand separators) before parsing
    var nominal = Number(($('#pemb-amount').val()||'0').toString().replace(/\D/g,''));
    if (!pelanggan || !kontrak || !nominal) { alert('Lengkapi pelanggan/kontrak/nominal'); return; }
    var payments = [];
    var remaining = nominal;
    $('#pemb-installments tbody tr').each(function(){
        if (remaining<=0) return;
        var $row = $(this);
        var chk = $row.find('.pemb-select').is(':checked');
        var insId = $row.data('id');
        var amount = Number($row.find('.pemb-select').data('amt'));
        var paid = Number($row.find('.pemb-select').data('paid'));
        var due = amount - paid;
        if (!chk) return;
        var take = Math.min(remaining, due);
        if (take>0) {
            payments.push({kontrak_installment_id: insId, amount: take, paid_at: formatLocalDatetime(new Date())});
            remaining -= take;
        }
    });
    if (remaining>0) {
        payments.push({kontrak_installment_id: null, amount: remaining, paid_at: formatLocalDatetime(new Date()), note: 'Kelebihan bayar'});
    }

    $.post(URL_CREATE, {pelanggan_id:pelanggan, kontrak_id:kontrak, payments: payments}, function(res){
            if (res.success) {
            if (confirm('Pembayaran tersimpan. Cetak struk?')) {
                var sep = (URL_PRINT.indexOf('?') === -1) ? '?' : '&';
                window.open(URL_PRINT + sep + 'id=' + res.pembayaran_id, '_blank');
            }
            window.location.href = URL_INDEX;
        } else {
            alert('Gagal: '+(res.message || JSON.stringify(res.errors||res)));
        }
    }, 'json');
});
JS;

$this->registerJs($js, \yii\web\View::POS_READY);
?>
