<?php
use yii\helpers\Html;
use yii\widgets\LinkPager;
/* @var $models array */
/* @var $pagination \yii\data\Pagination */
?>
<div class="table-responsive">
    <table class="table table-sm table-striped">
        <thead><tr><th>No</th><th>Nomor</th><th>Kontrak</th><th>Pelanggan</th><th>Tanggal</th><th>Total Dibayar</th><th></th></tr></thead>
        <tbody>
        <?php foreach($models as $m): ?>
            <tr>
                <td><?= Html::encode($m->id) ?></td>
                <td><?= Html::encode($m->nomor) ?></td>
                <td>
                    <?php if (!empty($m->kontrak) && !empty($m->kontrak->nomor)): ?>
                        <?php $histUrl = \yii\helpers\Url::to(['pembayaran/history','kontrak_id'=>$m->kontrak->id]); ?>
                        <?= Html::a(Html::encode($m->kontrak->nomor), $histUrl) ?>
                    <?php else: ?>
                        <?= Html::encode($m->kontrak_id) ?>
                    <?php endif; ?>
                </td>
                <td><?= Html::encode($m->pelanggan_id) ?></td>
                <td><?= Yii::$app->formatter->asDatetime($m->created_at,'short') ?></td>
                <td>Rp <?= number_format($m->total_bayar,0,',','.') ?></td>
                <td>
                    <a class="btn btn-sm btn-outline-secondary me-1" href="<?= \yii\helpers\Url::to(['pembayaran/view','id'=>$m->id])?>">Lihat</a>
                    <?= Html::a('Hapus', ['pembayaran/delete','id'=>$m->id], ['class'=>'btn btn-sm btn-outline-danger','data'=>['method'=>'post','confirm'=>'Hapus pembayaran ini?']]) ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
<?php if (isset($pagination) && $pagination->totalCount > $pagination->pageSize): ?>
    <?= LinkPager::widget(['pagination'=>$pagination]) ?>
<?php endif; ?>
