<?php
use yii\helpers\Html;
use yii\helpers\Url;

/* Fixed Pelanggan view: details and thumbnails with AJAX delete */

/* @var $this yii\web\View */
/* @var $model app\models\Pelanggan */

$this->title = $model->nama;
$this->params['breadcrumbs'][] = ['label' => 'Pelanggan', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="pelanggan-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Ubah', ['update', 'kode_pelanggan' => $model->kode_pelanggan], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Hapus', ['delete', 'kode_pelanggan' => $model->kode_pelanggan], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Apakah Anda yakin ingin menghapus item ini?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <table class="table table-bordered">
        <tr><th>Kode Pelanggan</th><td><?= Html::encode($model->kode_pelanggan) ?></td></tr>
        <tr><th>Nama</th><td><?= Html::encode($model->nama) ?></td></tr>
        <tr><th>Alamat</th><td><?= nl2br(Html::encode($model->alamat)) ?></td></tr>
        <tr><th>Foto Lainnya</th><td>
            <div style="display:flex;flex-wrap:wrap;gap:8px;">
            <?php
            if (!empty($model->foto_lainnya)) {
                $parts = explode('|', $model->foto_lainnya);
                $web = Yii::getAlias('@web'); $webroot = Yii::getAlias('@webroot');
                foreach ($parts as $p) {
                    if (!$p) continue;
                    $name = basename($p);
                    $thumbPath = $webroot . '/uploads/pelanggan/thumbs/' . $name;
                    $imgUrl = is_file($thumbPath) ? $web . '/uploads/pelanggan/thumbs/' . $name : $web . '/uploads/pelanggan/' . $name;
                    ?>
                    <div class="existing-foto-lainnya" style="position:relative;display:inline-block;margin:4px;">
                        <?= Html::img($imgUrl, ['style'=>'max-width:120px;display:block;']) ?>
                        <?= Html::button('Hapus', [
                            'class'=>'btn btn-danger btn-sm delete-photo-btn',
                            'data-file'=>$p,
                            'data-url'=>Url::to(['pelanggan/delete-photo','kode_pelanggan'=>$model->kode_pelanggan]),
                            'style'=>'position:absolute;top:4px;right:4px;'
                        ]) ?>
                    </div>
                    <?php
                }
            }
            ?>
            </div>
        </td></tr>
    </table>

</div>

<?php
$js = <<<'JS'
;(function(){
    function csrf(){var m=document.querySelector('meta[name="csrf-token"]');return m?m.getAttribute('content'):''}
    document.addEventListener('click',function(e){
        var btn = e.target.closest && e.target.closest('.delete-photo-btn'); if(!btn) return;
        e.preventDefault(); if(!confirm('Hapus gambar ini?')) return;
        var file = btn.getAttribute('data-file'), url = btn.getAttribute('data-url');
        var xhr = new XMLHttpRequest(); xhr.open('POST', url, true);
        xhr.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
        xhr.setRequestHeader('X-Requested-With','XMLHttpRequest');
        var token = csrf(); xhr.onreadystatechange = function(){ if(xhr.readyState!==4) return; try{ var res = JSON.parse(xhr.responseText); if(res && res.success){ var node = btn.closest('.existing-foto-lainnya'); if(node) node.parentNode.removeChild(node); } else { alert(res && res.message ? res.message : 'Gagal menghapus gambar'); } } catch(ex){ location.reload(); } };
        xhr.send('_csrf='+encodeURIComponent(token)+'&file='+encodeURIComponent(file));
    }, false);
})();
JS;
$this->registerJs($js, \yii\web\View::POS_END);
?>
