﻿<?php
use yii\helpers\Html;
use yii\helpers\Url;

/* Pelanggan detail view (clean)
 * Shows thumbnails for `foto`, `foto_ktp`, and `foto_lainnya`.
 * Provides per-image AJAX delete using `pelanggan/delete-photo`.
 * @var $this yii\web\View
 * @var $model app\models\Pelanggan
 */

$this->title = isset($model->nama) ? $model->nama : 'Pelanggan';
$this->params['breadcrumbs'][] = ['label' => 'Pelanggan', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="pelanggan-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <!-- action buttons removed per UX: actions handled via index action buttons/modal -->

    <table class="table table-bordered">
        <tr><th>Kode Pelanggan</th><td><?= Html::encode($model->kode_pelanggan) ?></td></tr>
        <tr><th>Nama</th><td><?= Html::encode($model->nama) ?></td></tr>
        <tr><th>No WA</th><td>
            <?php
            // prefer `no_whatsapp` (model), fall back to `no_handphone` if available
            $wa = trim($model->no_whatsapp ?? $model->no_handphone ?? '');
            if ($wa !== '') {
                // normalize number: remove non-digits and leading +; convert leading 0 to country code 62 if present
                $norm = preg_replace('/[^0-9+]/', '', $wa);
                $norm = ltrim($norm, '+');
                if (strpos($norm, '0') === 0) {
                    $norm = '62' . ltrim($norm, '0');
                }
                $waUrl = 'https://wa.me/' . $norm;
                echo Html::a(Html::encode($wa) . ' ', $waUrl, ['target' => '_blank', 'class' => 'btn btn-success btn-sm']);
            } else {
                echo '<span class="text-muted">-</span>';
            }
            ?>
        </td></tr>
        <tr><th>No KTP</th><td>
            <?php
            $ktp = trim($model->no_ktp ?? '');
            if ($ktp !== '') {
                echo Html::encode($ktp);
            } else {
                echo '<span class="text-muted">-</span>';
            }
            ?>
        </td></tr>
        <tr><th>Alamat</th><td><?= nl2br(Html::encode($model->alamat)) ?></td></tr>
        <tr><th>Foto</th><td>
            <?php if (!empty($model->foto)): 
                $web = Yii::getAlias('@web'); $webroot = Yii::getAlias('@webroot');
                $thumb = $webroot . '/uploads/pelanggan/thumbs/' . basename($model->foto);
                $orig = $webroot . '/uploads/pelanggan/' . basename($model->foto);
                $imgUrl = is_file($thumb) ? $web . '/uploads/pelanggan/thumbs/' . basename($model->foto) : ($web . '/uploads/pelanggan/' . basename($model->foto));
                ?>
                <div style="position:relative;display:inline-block;">
                    <?= Html::img($imgUrl, ['style'=>'max-width:150px;display:block;']) ?>
                    <!-- delete button removed in detail view -->
                </div>
            <?php endif; ?>
        </td></tr>
        <tr><th>Foto KTP</th><td>
            <?php if (!empty($model->foto_ktp)): 
                $web = Yii::getAlias('@web'); $webroot = Yii::getAlias('@webroot');
                $thumb = $webroot . '/uploads/pelanggan/thumbs/' . basename($model->foto_ktp);
                $orig = $webroot . '/uploads/pelanggan/' . basename($model->foto_ktp);
                $imgKtp = is_file($thumb) ? $web . '/uploads/pelanggan/thumbs/' . basename($model->foto_ktp) : ($web . '/uploads/pelanggan/' . basename($model->foto_ktp));
                ?>
                <div style="position:relative;display:inline-block;">
                    <?= Html::img($imgKtp, ['style'=>'max-width:150px;display:block;']) ?>
                    <!-- delete button removed in detail view -->
                </div>
            <?php endif; ?>
        </td></tr>
        <tr><th>Foto Lainnya</th><td>
            <div style="display:flex;flex-wrap:wrap;gap:8px;">
            <?php
            if (!empty($model->foto_lainnya)) {
                $parts = explode('|', $model->foto_lainnya);
                $web = Yii::getAlias('@web'); $webroot = Yii::getAlias('@webroot');
                foreach ($parts as $p) {
                    if (!$p) continue;
                    $name = basename($p);
                    $thumbPath = $webroot . '/uploads/pelanggan/thumbs/' . $name;
                    $imgUrl = is_file($thumbPath) ? $web . '/uploads/pelanggan/thumbs/' . $name : $web . '/uploads/pelanggan/' . $name;
                    ?>
                    <div class="existing-foto-lainnya" style="position:relative;display:inline-block;margin:4px;">
                        <?= Html::img($imgUrl, ['style'=>'max-width:120px;display:block;']) ?>
                        <!-- delete button removed in detail view -->
                    </div>
                    <?php
                }
            }
            ?>
            </div>
        </td></tr>
    </table>

</div>

<?php
$js = <<<'JS'
;(function(){
    function csrf(){var m=document.querySelector('meta[name="csrf-token"]');return m?m.getAttribute('content'):''}
    document.addEventListener('click',function(e){
        var btn = e.target.closest && e.target.closest('.delete-photo-btn'); if(!btn) return;
        e.preventDefault(); if(!confirm('Hapus gambar ini?')) return;
        var file = btn.getAttribute('data-file'), url = btn.getAttribute('data-url');
        var xhr = new XMLHttpRequest(); xhr.open('POST', url, true);
        xhr.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
        xhr.setRequestHeader('X-Requested-With','XMLHttpRequest');
        var token = csrf(); xhr.onreadystatechange = function(){ if(xhr.readyState!==4) return; try{ var res = JSON.parse(xhr.responseText); if(res && res.success){
                // If button requests a full refresh (main foto/foto_ktp), reload page
                if(btn.getAttribute('data-refresh') === '1'){ location.reload(); return; }
                var node = btn.closest('.existing-foto-lainnya'); if(node){ node.parentNode.removeChild(node); return; }
                // fallback: remove the closest inline wrapper (for foto/foto_ktp)
                var wrap = btn.closest('div'); if(wrap){ wrap.parentNode.removeChild(wrap); return; }
            } else { alert(res && res.message ? res.message : 'Gagal menghapus gambar'); } } catch(ex){ location.reload(); } };
        xhr.send('_csrf='+encodeURIComponent(token)+'&file='+encodeURIComponent(file));
    }, false);
})();
JS;
$this->registerJs($js, \yii\web\View::POS_END);
