<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Pelanggan';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="pelanggan-index">

    <h1><?= Html::encode($this->title) ?></h1>

        <p>
                <?= Html::a('Buat Pelanggan', ['create'], ['class' => 'btn btn-success', 'id' => 'btn-create-pelanggan', 'data-url' => \yii\helpers\Url::to(['create'])]) ?>
        </p>

        <!-- reuse modal used for barang (modal-create-barang) to display ajax content -->
        <div class="modal fade" id="modal-create-barang" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" style="margin:1.5rem auto;">
                <div class="modal-content" style="padding:0.75rem;">
                    <!-- ajax content -->
                </div>
            </div>
        </div>

        <?php $this->registerJsFile('@web/js/barang-form.js', ['depends' => [\yii\bootstrap5\BootstrapPluginAsset::class]]); ?>
        <?php $this->registerJs(<<<'JS'
        // load create form into modal
        $(document).on('click', '#btn-create-pelanggan', function(e){
                e.preventDefault();
                var url = $(this).data('url');
                $.get(url, function(html){
                        var $m = $('#modal-create-barang');
                        $m.find('.modal-content').html(html);
                        $m.modal('show');
                        try{ if(typeof window.initBarangForm === 'function') window.initBarangForm(document.getElementById('modal-create-barang')); }catch(e){}
                });
        });
        JS
        ); ?>
    <?php $perPage = (int)Yii::$app->request->get('per-page', 15); ?>

    <!-- Pencarian gabungan (kode, nama, no_ktp) -->
    <?php
        $filterQ = Html::encode(Yii::$app->request->get('q', ''));
    ?>
    <div class="card mb-3">
        <div class="card-body">
            <?= Html::beginForm(['index'], 'get', ['class' => 'row g-2 align-items-end']) ?>
                <div class="col-auto flex-fill" style="min-width:240px;">
                    <label class="form-label small mb-1">Pencarian</label>
                    <?= Html::textInput('q', $filterQ, ['class' => 'form-control form-control-sm', 'placeholder' => 'Cari kode, nama, atau No. KTP']) ?>
                </div>
                <?= Html::hiddenInput('per-page', $perPage) ?>
                <div class="col-auto">
                    <?= Html::submitButton('Cari', ['class' => 'btn btn-primary btn-sm']) ?>
                    <?= Html::a('Reset', ['index'], ['class' => 'btn btn-outline-secondary btn-sm ms-2']) ?>
                </div>
            <?= Html::endForm() ?>
        </div>
    </div>

    <?php
        $params = Yii::$app->request->get();
        $perPageFormParts = [];
        foreach ($params as $k => $v) {
            if ($k === 'per-page' || $k === 'page') continue;
            if (is_array($v)) {
                foreach ($v as $val) {
                    $perPageFormParts[] = \yii\helpers\Html::hiddenInput($k . '[]', $val);
                }
            } else {
                $perPageFormParts[] = \yii\helpers\Html::hiddenInput($k, $v);
            }
        }
        $perPageFormParts[] = \yii\helpers\Html::dropDownList('per-page', $perPage, [15=>15,25=>25,50=>50,100=>100], ['class'=>'form-select form-select-sm','style'=>'width:90px;display:inline-block;','onchange'=>'this.form.submit()']);
        $perPageForm = \yii\helpers\Html::beginForm(['index'], 'get', ['class'=>'d-inline-block ms-3']) . implode("\n", $perPageFormParts) . \yii\helpers\Html::endForm();

    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'summary' => "Menampilkan {begin}-{end} dari {totalCount} item.",
        'layout' => "{items}\n<div class='d-flex justify-content-between align-items-center mt-3'>\n    <div class='text-muted d-flex align-items-center'>{summary} $perPageForm</div>\n    <div>{pager}</div>\n</div>",
        'pager' => [
            'options' => ['class' => 'pagination'],
            'linkOptions' => ['class' => 'page-link px-2'],
            'pageCssClass' => 'mx-1',
            'prevPageLabel' => '<',
            'nextPageLabel' => '>',
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'kode_pelanggan',
            'nama',
            'no_ktp',

            [
                'class' => 'yii\grid\ActionColumn',
                'template' => '{view} {update} {delete}',
                'buttons' => [
                    'view' => function($url, $model, $key){
                        $u = ['view', 'kode_pelanggan' => $model->kode_pelanggan];
                        return Html::a('Lihat', $u, ['class' => 'btn btn-sm btn-outline-secondary action-view', 'data-url' => \yii\helpers\Url::to($u)]);
                    },
                    'update' => function($url, $model, $key){
                        $u = ['update', 'kode_pelanggan' => $model->kode_pelanggan];
                        return Html::a('Ubah', $u, ['class' => 'btn btn-sm btn-outline-primary action-update', 'data-url' => \yii\helpers\Url::to($u)]);
                    },
                    'delete' => function($url, $model, $key){
                        $u = ['delete', 'kode_pelanggan' => $model->kode_pelanggan];
                        return Html::a('Hapus', $u, ['class' => 'btn btn-sm btn-outline-danger action-delete', 'data-url' => \yii\helpers\Url::to($u)]);
                    },
                ],
            ],
        ],
    ]); ?>

    

</div>
