<?php

use yii\widgets\ActiveForm;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Pelanggan */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="pelanggan-form">

    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

    <?= $form->field($model, 'kode_pelanggan')->textInput(['maxlength' => true, 'readonly' => $model->isNewRecord ? true : false]) ?>

    <?= $form->field($model, 'nama')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'alias')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'no_ktp')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'no_whatsapp')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'no_handphone')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'alamat')->textarea(['rows' => 4]) ?>

    <?= $form->field($model, 'sosial_media')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'referal')->textInput(['maxlength' => true]) ?>

    <?php if (!empty($model->foto)):
        $fotoVal = $model->foto;
        // prepare possible relative paths
        $thumbRel = (strpos($fotoVal, 'uploads/') === 0) ? $fotoVal : 'uploads/pelanggan/thumbs/' . $fotoVal;
        $origRel = (strpos($fotoVal, 'uploads/') === 0) ? $fotoVal : 'uploads/pelanggan/' . $fotoVal;
        $thumbFile = Yii::getAlias('@webroot') . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $thumbRel);
        $origFile = Yii::getAlias('@webroot') . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $origRel);
        $url = null;
        if (file_exists($thumbFile)) {
            $url = Yii::getAlias('@web') . '/' . $thumbRel;
        } elseif (file_exists($origFile)) {
            $url = Yii::getAlias('@web') . '/' . $origRel;
        }
        if ($url) {
            echo Html::tag('p', 'Current foto: ' . Html::encode(basename($fotoVal)));
            echo Html::beginTag('div', ['style'=>'position:relative;display:inline-block;']);
            echo Html::img($url, ['style'=>'max-width:200px;display:block;']);
            echo Html::button('Hapus', [
                'class'=>'btn btn-danger btn-sm delete-photo-btn',
                'data-file'=>$fotoVal,
                'data-url'=>\yii\helpers\Url::to(['pelanggan/delete-photo','kode_pelanggan'=>$model->kode_pelanggan]),
                'data-refresh'=>'1',
                'style'=>'position:absolute;top:6px;right:6px;'
            ]);
            echo Html::endTag('div');
        } else {
            echo Html::tag('p', 'Current foto: ' . Html::encode($fotoVal));
        }
    endif; ?>

    <?= $form->field($model, 'fotoFile')->fileInput(['accept' => 'image/*']) ?>
    <div id="pelanggan-foto-preview" style="margin-top:8px;"></div>

    <?php if (!empty($model->foto_ktp)):
        $ktpVal = $model->foto_ktp;
        $thumbRelKtp = (strpos($ktpVal, 'uploads/') === 0) ? $ktpVal : 'uploads/pelanggan/thumbs/' . $ktpVal;
        $origRelKtp = (strpos($ktpVal, 'uploads/') === 0) ? $ktpVal : 'uploads/pelanggan/' . $ktpVal;
        $thumbFileKtp = Yii::getAlias('@webroot') . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $thumbRelKtp);
        $origFileKtp = Yii::getAlias('@webroot') . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $origRelKtp);
        $urlKtp = null;
        if (file_exists($thumbFileKtp)) {
            $urlKtp = Yii::getAlias('@web') . '/' . $thumbRelKtp;
        } elseif (file_exists($origFileKtp)) {
            $urlKtp = Yii::getAlias('@web') . '/' . $origRelKtp;
        }
        if ($urlKtp) {
            echo Html::tag('p', 'Current foto KTP: ' . Html::encode(basename($ktpVal)));
            echo Html::beginTag('div', ['style'=>'position:relative;display:inline-block;']);
            echo Html::img($urlKtp, ['style'=>'max-width:200px;display:block;']);
            echo Html::button('Hapus', [
                'class'=>'btn btn-danger btn-sm delete-photo-btn',
                'data-file'=>$ktpVal,
                'data-url'=>\yii\helpers\Url::to(['pelanggan/delete-photo','kode_pelanggan'=>$model->kode_pelanggan]),
                'data-refresh'=>'1',
                'style'=>'position:absolute;top:6px;right:6px;'
            ]);
            echo Html::endTag('div');
        } else {
            echo Html::tag('p', 'Current foto KTP: ' . Html::encode($ktpVal));
        }
    endif; ?>

    <?= $form->field($model, 'fotoKtpFile')->fileInput(['accept' => 'image/*']) ?>
    <div id="pelanggan-ktp-preview" style="margin-top:8px;"></div>

    <?= $form->field($model, 'fotoLainnyaFiles[]')->fileInput(['multiple' => true, 'accept' => 'image/*']) ?>
    <div id="pelanggan-lainnya-preview" style="margin-top:8px;display:flex;flex-wrap:wrap;gap:8px;"></div>

    <?php if (!empty($model->foto_lainnya)):
        $parts = explode('|', $model->foto_lainnya);
        echo '<div style="margin-top:8px;display:flex;flex-wrap:wrap;gap:8px;">';
        foreach ($parts as $p) {
            if (!$p) continue;
            $val = $p;
            $thumbRel = (strpos($val, 'uploads/') === 0) ? $val : 'uploads/pelanggan/thumbs/' . $val;
            $origRel = (strpos($val, 'uploads/') === 0) ? $val : 'uploads/pelanggan/' . $val;
            $thumbFile = Yii::getAlias('@webroot') . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $thumbRel);
            $origFile = Yii::getAlias('@webroot') . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $origRel);
            $url = null;
            if (file_exists($thumbFile)) {
                $url = Yii::getAlias('@web') . '/' . $thumbRel;
            } elseif (file_exists($origFile)) {
                $url = Yii::getAlias('@web') . '/' . $origRel;
            }
            if ($url) {
                echo Html::beginTag('div', ['class'=>'existing-foto-lainnya','style'=>'position:relative;']);
                echo Html::img($url, ['style'=>'max-width:120px;margin:4px;display:block;']);
                echo Html::button('Hapus', [
                    'class'=>'btn btn-danger btn-sm delete-photo-btn',
                    'data-file'=>$val,
                    'data-kode'=>$model->kode_pelanggan,
                    'data-url'=>\yii\helpers\Url::to(['pelanggan/delete-photo','kode_pelanggan'=>$model->kode_pelanggan]),
                    'style'=>'position:absolute;top:4px;right:4px;'
                ]);
                echo Html::endTag('div');
            } else {
                echo Html::beginTag('div', ['class'=>'existing-foto-lainnya','style'=>'position:relative;']);
                echo Html::tag('div', Html::encode(basename($val)), ['style'=>'max-width:120px;margin:4px;']);
                echo Html::button('Hapus', [
                    'class'=>'btn btn-danger btn-sm delete-photo-btn',
                    'data-file'=>$val,
                    'data-kode'=>$model->kode_pelanggan,
                    'data-url'=>\yii\helpers\Url::to(['pelanggan/delete-photo','kode_pelanggan'=>$model->kode_pelanggan]),
                    'style'=>'position:absolute;top:4px;right:4px;'
                ]);
                echo Html::endTag('div');
            }
        }
        echo '</div>';
    endif; ?>

    <?= $form->field($model, 'foto_lainnya')->textInput(['maxlength' => true]) ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Buat' : 'Simpan', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

    <?php
    $js = <<<'JS'
    // expose preview functions globally and bind change handlers
    window.previewImage = function(e, container){
        var file = e.target.files[0];
        var out = document.querySelector(container);
        if (out) out.innerHTML = '';
        if (!file) return;
        var reader = new FileReader();
        reader.onload = function(ev){
            var img = document.createElement('img');
            img.src = ev.target.result;
            img.style.maxWidth = '200px';
            if (out) out.appendChild(img);
        };
        reader.readAsDataURL(file);
    };

    window.previewMultiple = function(e, container){
        var files = e.target.files;
        var out = document.querySelector(container);
        if (out) out.innerHTML = '';
        if (!files || files.length === 0) return;
        for (var i=0;i<files.length;i++){
            (function(f){
                var reader = new FileReader();
                reader.onload = function(ev){
                    var img = document.createElement('img');
                    img.src = ev.target.result;
                    img.style.maxWidth = '120px';
                    img.style.marginRight = '6px';
                    if (out) out.appendChild(img);
                };
                reader.readAsDataURL(f);
            })(files[i]);
        }
    };

    // attach handlers when DOM is ready
    (function(){
        document.addEventListener('DOMContentLoaded', function(){
            var f = document.getElementById('pelanggan-fotofile');
            if (f) f.addEventListener('change', function(e){ window.previewImage(e, '#pelanggan-foto-preview'); });
            var k = document.getElementById('pelanggan-fotoktpfile');
            if (k) k.addEventListener('change', function(e){ window.previewImage(e, '#pelanggan-ktp-preview'); });
            var m = document.getElementById('pelanggan-fotolainnyafiles');
            if (m) m.addEventListener('change', function(e){ window.previewMultiple(e, '#pelanggan-lainnya-preview'); });
        });
    })();
    JS;
    $this->registerJs($js, \yii\web\View::POS_END);
    
    // Add delete-photo handler so "Hapus" buttons in the update form work via AJAX
    $delJs = <<<'JS'
    (function(){
        function csrf(){var m=document.querySelector('meta[name="csrf-token"]');return m?m.getAttribute('content'):''}
        document.addEventListener('click', function(e){
            var btn = e.target.closest && e.target.closest('.delete-photo-btn'); if(!btn) return;
            e.preventDefault(); if(!confirm('Hapus gambar ini?')) return;
            var file = btn.getAttribute('data-file'), url = btn.getAttribute('data-url');
            var xhr = new XMLHttpRequest(); xhr.open('POST', url, true);
            xhr.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
            xhr.setRequestHeader('X-Requested-With','XMLHttpRequest');
            var token = csrf();
            xhr.onreadystatechange = function(){ if(xhr.readyState!==4) return; try{ var res = JSON.parse(xhr.responseText); if(res && res.success){ if(btn.getAttribute('data-refresh')==='1'){ location.reload(); return; } var node = btn.closest('.existing-foto-lainnya'); if(node) node.parentNode.removeChild(node); } else { alert(res && res.message ? res.message : 'Gagal menghapus gambar'); } } catch(ex){ location.reload(); } };
            xhr.send('_csrf='+encodeURIComponent(token)+'&file='+encodeURIComponent(file));
        }, false);
    })();
    JS;
    $this->registerJs($delJs, \yii\web\View::POS_END);
    ?>

