<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body class="d-flex flex-column h-100">
<?php $this->beginBody() ?>

<header id="header">
    <?php
    // show uploaded logo if present, otherwise app name
    $logoWebPath = Yii::getAlias('@web') . '/uploads/logo.png';
    $logoFsPath = Yii::getAlias('@webroot') . DIRECTORY_SEPARATOR . 'uploads' . DIRECTORY_SEPARATOR . 'logo.png';
    $brandLabel = Yii::$app->name;
    if (file_exists($logoFsPath)) {
        $brandLabel = \yii\helpers\Html::img($logoWebPath, ['alt'=>Yii::$app->name, 'style'=>'height:30px;']);
    }
    NavBar::begin([
        'brandLabel' => $brandLabel,
        'brandUrl' => Yii::$app->homeUrl,
        'options' => ['class' => 'navbar-expand-md navbar-dark bg-dark fixed-top']
    ]);
    // Build nav items with permission-aware disabling (visible but not clickable if no permission)
    $user = Yii::$app->user->isGuest ? null : Yii::$app->user->identity;
    $can = function($perm) use ($user) {
        if (!$perm) return true; // public
        if (!$user) return false;
        // allow manageSettings/manageUsers as wildcard for Pengaturan
        return $user->hasPermission($perm) || $user->role === 'admin';
    };

    $items = [];
    $menuMap = [
        ['label' => 'Beranda', 'url' => ['/site/index'], 'perm' => null],
        ['label' => 'Barang', 'url' => ['/barang/index'], 'perm' => 'barang.view'],
        ['label' => 'Pelanggan', 'url' => ['/pelanggan/index'], 'perm' => 'pelanggan.view'],
        ['label' => 'Kontrak', 'url' => ['/kontrak/index'], 'perm' => 'kontrak.view'],
        ['label' => 'Pembayaran', 'url' => ['/pembayaran/index'], 'perm' => 'pembayaran.view'],
        ['label' => 'Pengaturan', 'url' => ['/setting/index'], 'perm' => 'manageSettings'],
        ['label' => 'Tentang', 'url' => ['/site/about'], 'perm' => null],
        ['label' => 'Kontak', 'url' => ['/site/contact'], 'perm' => null],
    ];
    foreach ($menuMap as $m) {
        if ($can($m['perm'])) {
            $items[] = ['label' => $m['label'], 'url' => $m['url']];
        } else {
            // visible but disabled
            $items[] = [
                'label' => $m['label'],
                'url' => '#',
                'linkOptions' => [
                    'class' => 'nav-link disabled',
                    'style' => 'color: rgba(255,255,255,0.35); text-decoration: none;',
                    'onclick' => 'return false;',
                    'tabindex' => '-1',
                    'aria-disabled' => 'true',
                    'title' => 'Anda tidak memiliki izin untuk mengakses halaman ini'
                ],
                'options' => ['class' => 'nav-item'],
            ];
        }
    }

    // auth/menu item
    if (Yii::$app->user->isGuest) {
        $items[] = ['label' => 'Masuk', 'url' => ['/site/login']];
    } else {
        $items[] = '<li class="nav-item">'
            . Html::beginForm(['/site/logout'])
            . Html::submitButton(
                'Keluar (' . Yii::$app->user->identity->username . ')',
                ['class' => 'nav-link btn btn-link logout']
            )
            . Html::endForm()
            . '</li>';
    }

    echo Nav::widget([
        'options' => ['class' => 'navbar-nav'],
        'items' => $items,
    ]);
    NavBar::end();
    ?>
</header>

<main id="main" class="flex-shrink-0" role="main">
    <div class="container">
        <?php if (!empty($this->params['breadcrumbs'])): ?>
            <?= Breadcrumbs::widget(['links' => $this->params['breadcrumbs']]) ?>
        <?php endif ?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</main>

<footer id="footer" class="mt-auto py-3 bg-light">
    <div class="container">
        <div class="row text-muted">
            <div class="col-md-6 text-center text-md-start">&copy; Perusahaan Saya <?= date('Y') ?></div>
            <div class="col-md-6 text-center text-md-end"><?= Yii::powered() ?></div>
        </div>
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
