<?php
/* @var $model app\models\Kontrak */
/* @var $installments array */
?>
<html>
<head>
    <meta charset="utf-8" />
    <title>Jadwal Cicilan - <?=$model->nomor?></title>
    <style>
        body{font-family:Arial,Helvetica,sans-serif;font-size:13px;padding:20px}
        table{width:100%;border-collapse:collapse}
        table th, table td{border:1px solid #ddd;padding:6px}
    </style>
</head>
<body>
    <h2>Jadwal Cicilan: <?=$model->nomor?> <?php if($model->is_custom_installment): ?><span style="background:#ffc107;padding:2px 6px;border-radius:4px;color:#000;margin-left:8px;font-size:12px">Kustom Cicilan</span><?php endif; ?></h2>
    <p><strong>Pelanggan:</strong> <?=isset($model->pelanggan->nama)?$model->pelanggan->nama:'-'?></p>

    <table>
        <thead><tr><th>Periode</th><th>Jatuh Tempo</th><th>Jumlah (Rp)</th><th>Status</th></tr></thead>
        <tbody>
        <?php foreach($installments as $ins): ?>
            <tr>
                <td><?=$ins->periode?></td>
                <td><?=Yii::$app->formatter->asDate($ins->due_date,'long')?></td>
                <td>Rp <?=number_format($ins->amount,0,',','.')?></td>
                <td><?=($ins->paid ? 'Lunas' : 'Belum')?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <div style="margin-top:18px">
        <button onclick="window.print()">Cetak</button>
        <button onclick="window.close()">Tutup</button>
    </div>
</body>
</html>
