<?php
/* @var $model app\models\Kontrak */
?>
<html>
<head>
    <meta charset="utf-8" />
    <title>Cetak Kontrak - <?=$model->nomor?></title>
    <style>
        body{font-family:Arial,Helvetica,sans-serif;font-size:13px;padding:20px}
        h2{margin-bottom:4px}
        table{width:100%;border-collapse:collapse}
        table th, table td{border:1px solid #ddd;padding:6px}
        .meta{margin-bottom:12px}
    </style>
</head>
<body>
    <h2>Kontrak: <?=$model->nomor?></h2>
    <div class="meta">
        <strong>Pelanggan:</strong> <?=isset($model->pelanggan->nama)?$model->pelanggan->nama:'-'?> <?php if($model->is_custom_installment): ?><span style="background:#ffc107;padding:2px 6px;border-radius:4px;color:#000;margin-left:8px;font-size:12px">Kustom Cicilan</span><?php endif; ?><br>
        <strong>Tanggal Mulai:</strong> <?=Yii::$app->formatter->asDate($model->tanggal_mulai,'long')?><br>
        <strong>DP:</strong> Rp <?=number_format($model->dp,0,',','.')?> &nbsp; <strong>Margin/week:</strong> <?=$model->margin_per_week?>% &nbsp; <strong>Tenor:</strong> <?=$model->tenor?> <?=$model->tenor_unit?>
    </div>

    <h4>Daftar Barang</h4>
    <table>
        <thead><tr><th>Nama</th><th>Kode</th><th>Qty</th><th>Harga</th><th>Total</th></tr></thead>
        <tbody>
        <?php foreach($model->items as $it): ?>
            <tr>
                <td><?=isset($it->barang->nama)?$it->barang->nama:'-'?></td>
                <td><?=isset($it->barang->kode_barang)?$it->barang->kode_barang:'-'?></td>
                <td><?=$it->qty?></td>
                <td>Rp <?=number_format($it->harga,0,',','.')?></td>
                <td>Rp <?=number_format($it->harga*$it->qty,0,',','.')?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr><th colspan="4">Total Harga</th><th>Rp <?=number_format($model->total_harga,0,',','.')?></th></tr>
        </tfoot>
    </table>

    <div style="margin-top:18px">
        <button onclick="window.print()">Cetak</button>
        <button onclick="window.close()">Tutup</button>
    </div>
</body>
</html>
