<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\LinkPager;
/* @var $this yii.web.View */
?>
<?php
// register flatpickr (CDN) for nicer datepickers
$this->registerCssFile('https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css', ['depends'=>\yii\web\JqueryAsset::class]);
$this->registerJsFile('https://cdn.jsdelivr.net/npm/flatpickr', ['depends'=>\yii\web\JqueryAsset::class]);
$this->registerJs(<<<'JS'
flatpickr('input[name="from"]',{dateFormat:'Y-m-d',allowInput:true});
flatpickr('input[name="to"]',{dateFormat:'Y-m-d',allowInput:true});
JS
, \yii\web\View::POS_READY);
?>
<div class="container">
    <h3>Daftar Kontrak</h3>
    <p>
        <a class="btn btn-primary" href="<?=Url::to(['kontrak/create'])?>">Buat Kontrak Baru</a>
    </p>

    <form id="kontrak-filter-form" method="get" action="<?= Url::to(['kontrak/index'])?>" class="row g-3 mb-3 align-items-end">
        <div class="col-md-4">
            <label class="form-label">Cari</label>
            <input type="text" name="q" class="form-control" placeholder="Cari nomor / nama / no WA" value="<?= Html::encode($q ?? '') ?>">
        </div>
        <!-- single 'date' removed; use 'from' and 'to' range only -->
        <div class="col-md-2">
            <label class="form-label">Dari</label>
            <input type="date" name="from" class="form-control" value="<?= Html::encode($from ?? '') ?>">
        </div>
        <div class="col-md-2">
            <label class="form-label">Sampai</label>
            <input type="date" name="to" class="form-control" value="<?= Html::encode($to ?? '') ?>">
        </div>
        <div class="col-md-2 d-flex">
            <button class="btn btn-secondary me-2" type="submit">Filter</button>
            <a class="btn btn-link align-self-start" href="<?= Url::to(['kontrak/index'])?>">Reset</a>
        </div>
    </form>

    <div id="kontrak-list-container">
        <?= $this->render('_list', ['models'=>$models,'pagination'=>$pagination,'q'=>$q,'from'=>$from,'to'=>$to]) ?>
    </div>
</div>

<div id="kontrak-list-loading" class="text-center my-2 d-none">
    <div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div>
</div>
<!-- Detail modal -->
<div class="modal fade" id="kontrak-detail-modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detail Kontrak</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="kontrak-detail-body">Memuat...</div>
        </div>
    </div>
</div>
<?php
// ensure filter form works reliably: build URL on submit (avoids issues with base URL or unexpected form behavior)
$ajaxUrl = Url::to(['kontrak/index'], true);
$js = "var AJAX_INDEX_URL = " . json_encode($ajaxUrl) . ";\n";
$js .= <<<'JS'
$('#kontrak-filter-form').on('submit', function(e){
    e.preventDefault();
    var q = $('input[name="q"]', this).val()||'';
    var from = $('input[name="from"]', this).val()||'';
    var to = $('input[name="to"]', this).val()||'';
    var params = {};
    if (q) params.q = q;
    if (from) params.from = from;
    if (to) params.to = to;
    console.log('Kontrak filter submit', params);
    var $spinner = $('#kontrak-list-loading');
    $spinner.removeClass('d-none');
    $.ajax({
        url: AJAX_INDEX_URL,
        method: 'GET',
        data: params,
        timeout: 10000,
        success: function(html){
            console.log('Kontrak filter success, replacing list');
            $('#kontrak-list-container').html(html);
        },
        error: function(xhr, status, err){
            console.error('Kontrak filter AJAX error', status, err);
            // fallback: build URL and redirect so user still sees filtered results
            var fallback = AJAX_INDEX_URL;
            var query = $.param(params);
            if (query) fallback += '?' + query;
            console.log('Falling back to', fallback);
            window.location.href = fallback;
        },
        complete: function(){
            $spinner.addClass('d-none');
        }
    });
});
// also support clicking pagination links by ajax (with logging/fallback)
$(document).on('click', '#kontrak-list-container .pagination a', function(e){
    e.preventDefault();
    var href = $(this).attr('href');
    console.log('Kontrak pagination click', href);
    var $spinner = $('#kontrak-list-loading');
    $spinner.removeClass('d-none');
    $.ajax({
        url: href,
        method: 'GET',
        timeout: 10000,
        success: function(html){
            console.log('Kontrak pagination success');
            $('#kontrak-list-container').html(html);
        },
        error: function(xhr, status, err){
            console.error('Kontrak pagination AJAX error', status, err);
            // fallback: full redirect
            window.location.href = href;
        },
        complete: function(){ $spinner.addClass('d-none'); }
    });
});
JS;
// modal handler: load kontrak detail into modal via AJAX
$js .= <<<'JS'
$(document).on('click', '.btn-view-detail', function(e){
    e.preventDefault();
    var url = $(this).data('url');
    $('#kontrak-detail-body').html('Memuat...');
    var modalEl = new bootstrap.Modal(document.getElementById('kontrak-detail-modal'));
    modalEl.show();
    $.get(url).done(function(html){
        $('#kontrak-detail-body').html(html);
    }).fail(function(){
        $('#kontrak-detail-body').html('<div class="text-danger">Gagal memuat detail kontrak.</div>');
    });
});
JS;

$this->registerJs($js, \yii\web\View::POS_READY);
?>
