<?php
use yii\helpers\Url;
/* @var $this yii\web\View */
?>
<div class="container">
    <h3>Buat Kontrak</h3>

    <style>
    /* Persempit kolom qty, perlebar harga & total */
    #items-table th.qty-col, #items-table td.qty-col { width: 80px; text-align: center; }
    #items-table th.harga-col, #items-table td.harga-col { width: 220px; text-align: right; }
    #items-table th.total-col, #items-table td.total-col { width: 220px; text-align: right; }
    #items-table td.action-col { width: 90px; }
    #items-table .qty-input { width: 70px; }
    </style>

    <form id="kontrak-form">
        <div class="form-group">
            <label>Pelanggan (nama / no KTP / no WA)</label>
            <div class="input-group">
                <select id="pelanggan-select" class="form-control" style="width:100%"></select>
                <div class="input-group-append">
                    <button type="button" id="btn-create-pelanggan" class="btn btn-outline-secondary">Buat Pelanggan</button>
                </div>
            </div>
            <input type="hidden" id="pelanggan-id" name="pelanggan_id">
            <div id="pelanggan-info" style="margin-top:8px;color:#555"></div>
            <div id="pelanggan-suggestions" style="position:relative;margin-top:6px"></div>
        </div>

        <div class="form-group">
            <label>Barang (multi)</label>
            <div class="input-group">
                <select id="barang-select" class="form-control" style="width:100%"></select>
                <div class="input-group-append">
                    <button type="button" id="btn-add-barang" class="btn btn-primary">Tambah</button>
                </div>
            </div>
            <div id="barang-suggestions" style="position:relative;margin-top:6px"></div>
            <table class="table table-sm" id="items-table" style="margin-top:8px">
                <thead>
                    <tr>
                        <th>Nama</th>
                        <th>Kode</th>
                        <th class="qty-col">Qty</th>
                        <th class="harga-col">Harga</th>
                        <th class="total-col">Total</th>
                        <th class="action-col"></th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            <div style="margin-top:6px;font-weight:600">Total Harga Barang: <span id="total-harga-barang">Rp 0</span></div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-3">
                    <label>DP (Rp)</label>
                    <div class="input-group">
                        <input type="text" class="form-control" id="dp_display" value="0">
                        <input type="hidden" id="dp" name="dp" value="0">
                    </div>
            </div>
            <div class="form-group col-md-3">
                <label>Margin per week (%)</label>
                <input type="number" step="0.1" class="form-control" id="margin" name="margin_per_week" value="2">
            </div>
            <div class="form-group col-md-3">
                <label>Tenor</label>
                <input type="number" class="form-control" id="tenor" name="tenor" value="10">
            </div>
            <div class="form-group col-md-3">
                <label>Unit</label>
                <select id="tenor-unit" name="tenor_unit" class="form-control"><option value="week">Minggu</option><option value="month">Bulan</option></select>
            </div>
        </div>

        <div class="form-row align-items-center">
            <div class="form-group col-md-4">
                <label>Tanggal Mulai</label>
                <input type="date" id="tanggal-mulai" name="tanggal_mulai" class="form-control" value="<?=date('Y-m-d')?>">
                <div id="tanggal-mulai-display" style="margin-top:6px;color:#666"></div>
            </div>
            <div class="form-group col-md-4">
                <label>Kustom Cicilan (Rp) — kosong biar dihitung otomatis</label>
                <input type="number" step="1" min="0" id="custom-cicilan" name="custom_installment_amount" class="form-control">
            </div>
        </div>

        <div class="form-group">
            <button type="button" id="btn-preview" class="btn btn-info">Preview Cicilan</button>
            <button type="button" id="btn-save" class="btn btn-success">Simpan Kontrak</button>
        </div>
    </form>

    <h4>Preview</h4>
    <div id="preview-summary" style="margin-bottom:12px"></div>
    <table class="table table-bordered" id="preview-table">
        <thead><tr><th>Periode</th><th>Tanggal Jatuh Tempo</th><th>Jumlah (Rp)</th></tr></thead>
        <tbody></tbody>
    </table>
</div>

<!-- Pelanggan modal -->
<div class="modal" tabindex="-1" role="dialog" id="modal-pelanggan">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header"><h5 class="modal-title">Buat Pelanggan</h5></div>
      <div class="modal-body">
        <div class="form-group"><label>Nama</label><input type="text" id="p-nama" class="form-control"></div>
        <div class="form-group"><label>No KTP</label><input type="text" id="p-ktp" class="form-control"></div>
        <div class="form-group"><label>No WA</label><input type="text" id="p-wa" class="form-control"></div>
      </div>
      <div class="modal-footer">
        <button type="button" id="save-pelanggan" class="btn btn-primary">Simpan</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
      </div>
    </div>
  </div>
</div>

<?php
$urlSearchPelanggan = Url::to(['kontrak/search-pelanggan']);
$urlSearchBarang = Url::to(['kontrak/search-barang']);
$urlCreatePelanggan = Url::to(['kontrak/create-pelanggan']);
$urlCreateKontrak = Url::to(['kontrak/create']);
?>

<?php
// register local Select2 asset
use app\assets\Select2Asset;
Select2Asset::register($this);
?>

<?php
// Register the page JS at the end so jQuery and Select2 are available
$urlSearchPelanggan = $urlSearchPelanggan;
$urlSearchBarang = $urlSearchBarang;
$urlCreatePelanggan = $urlCreatePelanggan;
$urlCreateKontrak = $urlCreateKontrak;
$urlPrint = \yii\helpers\Url::to(['kontrak/print']);
$urlPrintSchedule = \yii\helpers\Url::to(['kontrak/print-schedule']);
$urlIndex = \yii\helpers\Url::to(['/kontrak/index']);

$js = <<<JS
/* Simple JS (jQuery expected) - registered at POS_END */
(function(){
    var selectedBarang = null;
    var items = [];

    function formatRupiah(n){return new Intl.NumberFormat('id-ID').format(Math.round(n));}
    function parseNumberFromString(s){
        if (s===undefined || s===null) return 0;
        var v = String(s).trim();
        // Normalize: remove dot thousand separators, convert comma decimal to dot
        v = v.replace(/\./g, '');
        v = v.replace(/,/g, '.');
        // strip any remaining nondigit except dot and minus
        v = v.replace(/[^0-9\.\-]/g,'');
        if (v==='') return 0;
        var num = parseFloat(v);
        if (isNaN(num)) return 0;
        // currency uses integer rupiah, round to nearest integer
        return Math.round(num);
    }

    // DP display formatting: visible input (#dp_display) and hidden numeric (#dp)
    function initDpFormatting(){
        // initialize display from hidden numeric
        var initial = parseFloat($('#dp').val())||0;
        $('#dp_display').val(formatRupiah(initial));

        // On focus, keep formatted text and move caret to end so typing continues nicely
        $('#dp_display').on('focus', function(){
            var n = parseNumberFromString($('#dp').val())||0;
            $(this).val(formatRupiah(n));
            // move caret to end
            try { this.setSelectionRange(this.value.length, this.value.length); } catch(e){}
        });

        // Live-format while typing: store numeric in hidden input and show formatted text
        $('#dp_display').on('input', function(){
            var el = this;
            var raw = $(el).val();
            var n = parseNumberFromString(raw) || 0;
            // update hidden numeric value
            $('#dp').val(Math.round(n));
            // format display
            var formatted = formatRupiah(n);
            // set formatted value and move caret to end so user can continue typing naturally
            $(el).val(formatted);
            try { el.setSelectionRange(formatted.length, formatted.length); } catch(e){}
        });

        // On blur ensure formatting is applied (already applied during input) and hidden is synced
        $('#dp_display').on('blur', function(){
            var n = parseNumberFromString($(this).val())||0;
            $('#dp').val(Math.round(n));
            $(this).val(formatRupiah(n));
        });
    }

    // initialize DP formatting
    initDpFormatting();

    // init Select2 untuk pelanggan (AJAX)
    $('#pelanggan-select').select2({
        placeholder: 'Cari pelanggan...',
        minimumInputLength: 1,
        allowClear: true,
        ajax: {
            url: '{$urlSearchPelanggan}',
            dataType: 'json',
            delay: 250,
            data: function(params){ return { q: params.term }; },
            processResults: function(data){ return { results: data.results || [] }; }
        },
        width: '100%'
    });
    $('#pelanggan-select').on('select2:select', function(e){
        var data = e.params.data; $('#pelanggan-id').val(data.id); $('#pelanggan-info').text('Pelanggan dipilih: '+data.text);
    });
    $('#pelanggan-select').on('select2:clear', function(){ $('#pelanggan-id').val(''); $('#pelanggan-info').text(''); });

    $('#btn-create-pelanggan').on('click', function(){ $('#modal-pelanggan').modal('show'); });
    $('#save-pelanggan').on('click', function(){
        var nama = $('#p-nama').val(); var ktp = $('#p-ktp').val(); var wa = $('#p-wa').val();
        $.post('{$urlCreatePelanggan}',{nama:nama,no_ktp:ktp,no_wa:wa}, function(res){
            if (res.success){ $('#pelanggan-id').val(res.kode || res.id); $('#pelanggan-info').text(res.nama+' (baru)'); $('#modal-pelanggan').modal('hide'); }
            else alert('Gagal: '+JSON.stringify(res.errors));
        },'json');
    });

    // init Select2 untuk barang (AJAX)
    $('#barang-select').select2({
        placeholder: 'Cari barang...',
        minimumInputLength: 1,
        allowClear: true,
        ajax: {
            url: '{$urlSearchBarang}',
            dataType: 'json',
            delay: 250,
            data: function(params){ return { q: params.term }; },
            processResults: function(data){ return { results: data.results || [] }; }
        },
        width: '100%'
    });
    // saat pilih barang, tambahkan ke list
    $('#barang-select').on('select2:select', function(e){
        var data = e.params.data; data.id = data.id || data.kode; addItem(data); // clear selection
        $('#barang-select').val(null).trigger('change');
    });
    // tombol tambah akan membuka dropdown select2
    $('#btn-add-barang').on('click', function(){ $('#barang-select').select2('open'); });

    function addItem(r){
        var existing = items.find(function(x){return x.barang_id==r.id});
        if (existing){ existing.qty++; } else {
            items.push({barang_id:r.id,nama:r.text,harga:r.harga,qty:1,kode:r.kode});
        }
        renderItems();
    }

    function renderItems(){
        var tbody = $('#items-table tbody'); tbody.empty();
        var grandTotal = 0;
        items.forEach(function(it,idx){
            var tr = $('<tr>');
            tr.append($('<td>').text(it.nama));
            tr.append($('<td>').text(it.kode));
            tr.append($('<td class="qty-col">').html('<input type="number" class="form-control form-control-sm qty qty-input" data-idx="'+idx+'" value="'+it.qty+'">'));
            tr.append($('<td class="harga-col">').text('Rp '+formatRupiah(it.harga)));
            tr.append($('<td class="total-col">').text('Rp '+formatRupiah(it.harga*it.qty)));
            grandTotal += (it.harga * (parseInt(it.qty)||0));
            tr.append($('<td class="action-col">').html('<button class="btn btn-sm btn-danger remove" data-idx="'+idx+'">Hapus</button>'));
            tbody.append(tr);
        });
        // update total harga barang display
        $('#total-harga-barang').text('Rp ' + formatRupiah(grandTotal));
    }

    $('#items-table').on('change','.qty',function(){ var idx=$(this).data('idx'); items[idx].qty = parseInt($(this).val())||1; renderItems(); });
    $('#items-table').on('click','.remove',function(){ var idx=$(this).data('idx'); items.splice(idx,1); renderItems(); });

    function computePreview(){
        var total = 0; items.forEach(function(it){ total += it.harga*it.qty; });
        var dp = parseFloat($('#dp').val())||0;
        var margin = parseFloat($('#margin').val())||2;
        var tenor = parseInt($('#tenor').val())||10;
        var unit = $('#tenor-unit').val();
        var custom = parseFloat($('#custom-cicilan').val())||0;
        var start = $('#tanggal-mulai').val();

        var tenor_weeks = (unit=='week')?tenor:tenor*4;
        var remaining = Math.max(0,total-dp);
        var total_with_interest = remaining + (remaining*(margin/100)*tenor_weeks);
        var periods = tenor;
        var per = custom>0?custom: Math.round((total_with_interest/periods)/1000)*1000;

        $('#preview-summary').html('Total barang: Rp '+formatRupiah(total)+', DP: Rp '+formatRupiah(dp)+', Cicilan per periode: Rp '+formatRupiah(per));

        var tbody = $('#preview-table tbody'); tbody.empty();
        for (var p=1;p<=periods;p++){
            var dt = new Date(start);
            if (unit=='week') dt.setDate(dt.getDate()+7*p); else dt.setMonth(dt.getMonth()+p);
            var displayDate = dt.toLocaleDateString('id-ID', {weekday:'long', year:'numeric', month:'long', day:'numeric'});
            tbody.append('<tr><td>'+p+'</td><td>'+displayDate+'</td><td>Rp '+formatRupiah(per)+'</td></tr>');
        }
    }

    $('#btn-preview').on('click', function(){
        if (items.length===0){ alert('Pilih minimal 1 barang untuk melakukan preview.'); return; }
        computePreview();
    });

    $('#tanggal-mulai').on('change', function(){ var d = new Date($(this).val()); $('#tanggal-mulai-display').text(d.toLocaleDateString('id-ID',{weekday:'long',year:'numeric',month:'long',day:'numeric'})); });

    $('#btn-save').on('click', function(){
        if (!$('#pelanggan-id').val()){ alert('Silakan pilih pelanggan terlebih dahulu.'); return; }
        if (items.length===0){ alert('Pilih minimal 1 barang'); return; }
        var payload = {};
        payload.pelanggan_id = $('#pelanggan-id').val();
        payload.dp = parseFloat($('#dp').val())||0;
        payload.margin_per_week = parseFloat($('#margin').val())||2;
        payload.tenor = parseInt($('#tenor').val())||10;
        payload.tenor_unit = $('#tenor-unit').val();
        payload.tanggal_mulai = $('#tanggal-mulai').val();
        var custom = parseFloat($('#custom-cicilan').val())||0; if (custom>0){ payload.is_custom_installment = 1; payload.custom_installment_amount = custom; }
        payload.items = items.map(function(it){ return {barang_id:it.barang_id,qty:it.qty,harga:it.harga,keterangan:''}; });

        $.post('{$urlCreateKontrak}', payload, function(res){
            if (res.success){
                if (confirm('Kontrak tersimpan (No: '+res.nomor+'). Cetak kontrak dan jadwal sekarang?')){
                    var id = res.kontrak_id;
                    var u1 = '{$urlPrint}' + '?id=' + id;
                    var u2 = '{$urlPrintSchedule}' + '?id=' + id;
                    window.open(u1,'_blank');
                    window.open(u2,'_blank');
                }
                window.location.href = '{$urlIndex}';
            } else alert('Gagal: '+(res.message||JSON.stringify(res.errors)||'error'));
        },'json');
    });

})();
JS;

$this->registerJs($js, \yii\web\View::POS_END);
?>
