<?php
use yii\helpers\Html;
use yii\widgets\LinkPager;
/* @var $models array */
/* @var $pagination \yii\data\Pagination|null */
/* @var $q string */
/* @var $from string */
/* @var $to string */
?>

    <div class="mb-3">
        <?php
        $count = isset($pagination) ? $pagination->totalCount : count($models);
        if (!empty($from) && !empty($to)) {
            $label = sprintf('Menampilkan kontrak: %s s/d %s', Html::encode($from), Html::encode($to));
        } elseif (!empty($from)) {
            $label = sprintf('Menampilkan kontrak dari: %s', Html::encode($from));
        } elseif (!empty($to)) {
            $label = sprintf('Menampilkan kontrak sampai: %s', Html::encode($to));
        } else {
            $label = sprintf('Menampilkan kontrak hari ini: %s', date('Y-m-d'));
        }
        ?>
        <strong><?= $label ?></strong>
        <span class="text-muted">&nbsp;(&nbsp;<?= $count ?> hasil&nbsp;)</span>
    </div>

    <div class="table-responsive">
    <table class="table table-striped table-sm">
        <thead><tr><th>No</th><th>Nomor</th><th>Pelanggan</th><th>Tgl Mulai</th><th>Total yang dicicil</th><th></th></tr></thead>
        <tbody>
        <?php foreach($models as $m): ?>
            <tr>
                <td><?= Html::encode($m->id) ?></td>
                <td><?= Html::encode($m->nomor) ?> <?php if($m->is_custom_installment): ?><span class="badge bg-warning text-dark">Kustom Cicilan</span><?php endif; ?></td>
                <td><?= Html::encode(isset($m->pelanggan->nama)?$m->pelanggan->nama:'-') ?></td>
                <td><?= Yii::$app->formatter->asDate($m->tanggal_mulai,'long') ?></td>
                <?php $payable = (float)$m->total_harga - (float)$m->dp; if($payable < 0) $payable = 0; ?>
                <td>Rp <?= number_format($payable,0,',','.') ?></td>
                <td>
                    <button class="btn btn-sm btn-info btn-view-detail" data-url="<?=\yii\helpers\Url::to(['kontrak/view','id'=>$m->id], true)?>">Lihat</button>
                    <a class="btn btn-sm btn-outline-secondary" href="<?=\yii\helpers\Url::to(['kontrak/print','id'=>$m->id])?>" target="_blank">Cetak</a>
                    <a class="btn btn-sm btn-outline-primary" href="<?=\yii\helpers\Url::to(['kontrak/print-schedule','id'=>$m->id])?>" target="_blank">Jadwal</a>
                    <?= Html::beginForm(['kontrak/delete','id'=>$m->id], 'post', ['style'=>'display:inline']) ?>
                        <?= Html::submitButton('Hapus', ['class'=>'btn btn-sm btn-danger','data-confirm'=>'Hapus kontrak ini?']) ?>
                    <?= Html::endForm() ?>
                </td>
            </tr>
        <?php endforeach;?>
        </tbody>
    </table>
    </div>

    <?php if (isset($pagination) && $pagination->totalCount > $pagination->pageSize): ?>
        <?= LinkPager::widget(['pagination'=>$pagination]) ?>
    <?php endif; ?>
