<?php
use yii\helpers\Html;
/* @var $model \app\models\Kontrak */
/* @var $items array */
/* @var $installments array */
?>
<div>
    <h5>Kontrak: <?= Html::encode($model->nomor) ?></h5>
    <p>
        <?= Html::a('History Transaksi', ['pembayaran/history','kontrak_id'=>$model->id], ['class'=>'btn btn-sm btn-outline-primary']) ?>
    </p>
    <p><strong>Pelanggan:</strong> <?= Html::encode($model->pelanggan->nama ?? '-') ?></p>
    <p><strong>Tanggal Mulai:</strong> <?= Yii::$app->formatter->asDate($model->tanggal_mulai,'long') ?></p>
    <p><strong>DP:</strong> Rp <?= number_format($model->dp,0,',','.') ?> &nbsp; <strong>Total Harga:</strong> Rp <?= number_format($model->total_harga,0,',','.') ?></p>

    <h6>Barang</h6>
    <div class="table-responsive">
    <table class="table table-sm">
        <thead><tr><th>Nama</th><th>Qty</th><th>Harga</th><th>Subtotal</th></tr></thead>
        <tbody>
        <?php foreach($items as $it):
            $b = $it->barang;
            $subtotal = $it->qty * $it->harga;
        ?>
            <tr>
                <td><?= Html::encode($b->nama ?? '-') ?></td>
                <td><?= (int)$it->qty ?></td>
                <td>Rp <?= number_format($it->harga,0,',','.') ?></td>
                <td>Rp <?= number_format($subtotal,0,',','.') ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>

    <h6>Jadwal Cicilan</h6>
    <div class="table-responsive">
    <table class="table table-sm">
        <thead><tr><th>Periode</th><th>Due Date</th><th>Jumlah</th></tr></thead>
        <tbody>
        <?php foreach($installments as $ins): ?>
            <tr>
                <td><?= (int)$ins->periode ?></td>
                <td><?= Yii::$app->formatter->asDate($ins->due_date,'long') ?></td>
                <td>Rp <?= number_format($ins->amount,0,',','.') ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>
</div>