<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Kategori';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="kategori-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Buat Kategori', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php $perPage = (int)Yii::$app->request->get('per-page', 15); ?>
    <?php
        $params = Yii::$app->request->get();
        $perPageFormParts = [];
        foreach ($params as $k => $v) {
            if ($k === 'per-page' || $k === 'page') continue;
            if (is_array($v)) {
                foreach ($v as $val) {
                    $perPageFormParts[] = \yii\helpers\Html::hiddenInput($k . '[]', $val);
                }
            } else {
                $perPageFormParts[] = \yii\helpers\Html::hiddenInput($k, $v);
            }
        }
        $perPageFormParts[] = \yii\helpers\Html::dropDownList('per-page', $perPage, [15=>15,25=>25,50=>50,100=>100], ['class'=>'form-select form-select-sm','style'=>'width:90px;display:inline-block;','onchange'=>'this.form.submit()']);
        $perPageForm = \yii\helpers\Html::beginForm(['index'], 'get', ['class'=>'d-inline-block ms-3']) . implode("\n", $perPageFormParts) . \yii\helpers\Html::endForm();

    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'summary' => "Menampilkan {begin}-{end} dari {totalCount} item.",
        'layout' => "{items}\n<div class='d-flex justify-content-between align-items-center mt-3'>\n    <div class='text-muted d-flex align-items-center'>{summary} $perPageForm</div>\n    <div>{pager}</div>\n</div>",
        'pager' => [
            'options' => ['class' => 'pagination'],
            'linkOptions' => ['class' => 'page-link px-2'],
            'pageCssClass' => 'mx-1',
            'prevPageLabel' => '<',
            'nextPageLabel' => '>',
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'nama',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>

    

</div>
