<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Barang */

$this->title = $model->nama;
$this->params['breadcrumbs'][] = ['label' => 'Barang', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="barang-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <!-- action buttons removed per UX: actions handled via index action buttons/modal -->

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'kode_barang',
            'nama',
            'deskripsi:ntext',
            [
                'attribute' => 'harga',
                'value' => function($model) {
                    return $model->harga !== null ? number_format($model->harga, 0, ',', '.') : null;
                },
            ],
            'satuan',
            'stok',
            'foto',
            'kategori',
        ],
    ]) ?>

</div>
