<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Barang';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="barang-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Buat Barang', ['create'], ['class' => 'btn btn-success', 'id' => 'btn-create-barang', 'data-url' => \yii\helpers\Url::to(['create'])]) ?>
    </p>

    <!-- Modal untuk form create -->
        <div class="modal fade" id="modal-create-barang" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" style="margin:1.5rem auto;">
                <div class="modal-content" style="padding:0.75rem;"> 
                    <!-- content akan diisi via AJAX -->
                </div>
            </div>
        </div>

    <?php $this->registerJsFile('@web/js/barang-form.js', ['depends' => [\yii\bootstrap5\BootstrapPluginAsset::class]]);
    $this->registerJs(<<<'JS'
    (function(){
        // buka modal dan load form
        $(document).on('click', '#btn-create-barang', function(e){
            e.preventDefault();
            var url = $(this).data('url');
            $.get(url, function(html){
                var $modal = $('#modal-create-barang');
                $modal.find('.modal-content').html(html);
                $modal.modal('show');
                // initialize any dynamic handlers inside the loaded form
                try{ if(typeof window.initBarangForm === 'function'){ window.initBarangForm(document.getElementById('modal-create-barang')); } }catch(e){}
            });
        });

        // intercept form submit inside modal
        $(document).on('beforeSubmit', '#modal-create-barang form', function(e){
            e.preventDefault();
            var form = $(this);
            var formData = new FormData(this);
            $.ajax({
                url: form.attr('action'),
                type: form.attr('method') || 'post',
                data: formData,
                processData: false,
                contentType: false,
                success: function(data) {
                    // jika server merespon JSON sukses
                    if (data && data.success) {
                        $('#modal-create-barang').modal('hide');
                        // reload halaman agar daftar ter-update
                        location.reload();
                        return;
                    }
                    // jika bukan JSON, gantikan isi modal (kemungkinan validasi gagal dan server mengirim HTML)
                    $('#modal-create-barang .modal-content').html(data);
                },
                error: function() {
                    alert('Terjadi kesalahan saat menyimpan.');
                }
            });
            return false;
        });
    })();
    JS
    ); ?>
    <?php $perPage = (int)Yii::$app->request->get('per-page', 15); ?>

    <!-- Pencarian gabungan (kode, nama, deskripsi) -->
    <?php
        $filterQ = Html::encode(Yii::$app->request->get('q', ''));
    ?>
    <div class="card mb-3">
        <div class="card-body">
            <?= Html::beginForm(['index'], 'get', ['class' => 'row g-2 align-items-end']) ?>
                <div class="col-auto flex-fill" style="min-width:240px;">
                    <label class="form-label small mb-1">Pencarian</label>
                    <?= Html::textInput('q', $filterQ, ['class' => 'form-control form-control-sm', 'placeholder' => 'Cari kode, nama, atau deskripsi']) ?>
                </div>
                <?= Html::hiddenInput('per-page', $perPage) ?>
                <div class="col-auto">
                    <?= Html::submitButton('Cari', ['class' => 'btn btn-primary btn-sm']) ?>
                    <?= Html::a('Reset', ['index'], ['class' => 'btn btn-outline-secondary btn-sm ms-2']) ?>
                </div>
            <?= Html::endForm() ?>
        </div>
    </div>
    <?php
        // build inline per-page form (no label, only dropdown)
        $params = Yii::$app->request->get();
        $perPageFormParts = [];
        foreach ($params as $k => $v) {
            if ($k === 'per-page' || $k === 'page') continue;
            if (is_array($v)) {
                foreach ($v as $val) {
                    $perPageFormParts[] = \yii\helpers\Html::hiddenInput($k . '[]', $val);
                }
            } else {
                $perPageFormParts[] = \yii\helpers\Html::hiddenInput($k, $v);
            }
        }
        $perPageFormParts[] = \yii\helpers\Html::dropDownList('per-page', $perPage, [15=>15,25=>25,50=>50,100=>100], ['class'=>'form-select form-select-sm','style'=>'width:90px;display:inline-block;','onchange'=>'this.form.submit()']);
        $perPageForm = \yii\helpers\Html::beginForm(['index'], 'get', ['class'=>'d-inline-block ms-3']) . implode("\n", $perPageFormParts) . \yii\helpers\Html::endForm();

    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'summary' => "Menampilkan {begin}-{end} dari {totalCount} item.",
        'layout' => "{items}\n<div class='d-flex justify-content-between align-items-center mt-3'>\n    <div class='text-muted d-flex align-items-center'>{summary} $perPageForm</div>\n    <div>{pager}</div>\n</div>",
        'pager' => [
            'options' => ['class' => 'pagination'],
            'linkOptions' => ['class' => 'page-link px-2'],
            'pageCssClass' => 'mx-1',
            'prevPageLabel' => '<',
            'nextPageLabel' => '>',
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'kode_barang',
            'nama',
            [
                'attribute' => 'harga',
                'value' => function($model) {
                    return $model->harga !== null ? number_format($model->harga, 0, ',', '.') : null;
                },
            ],
            'stok',
            'kategori',

            [
                'class' => 'yii\grid\ActionColumn',
                'template' => '{view} {update} {delete}',
                'buttons' => [
                    'view' => function($url, $model, $key){
                        $url = ['view', 'id' => $model->kode_barang];
                        return Html::a('Lihat', $url, ['class' => 'btn btn-sm btn-outline-secondary action-view', 'data-url' => \yii\helpers\Url::to($url), 'title' => 'Lihat']);
                    },
                    'update' => function($url, $model, $key){
                        $url = ['update', 'id' => $model->kode_barang];
                        return Html::a('Ubah', $url, ['class' => 'btn btn-sm btn-outline-primary action-update', 'data-url' => \yii\helpers\Url::to($url), 'title' => 'Ubah']);
                    },
                    'delete' => function($url, $model, $key){
                        $url = ['delete', 'id' => $model->kode_barang];
                        return Html::a('Hapus', $url, ['class' => 'btn btn-sm btn-outline-danger action-delete', 'data-url' => \yii\helpers\Url::to($url), 'title' => 'Hapus']);
                    },
                ],
            ],
        ],
    ]); ?>

    

</div>
