<?php

use yii\widgets\ActiveForm;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\Kategori;

/* @var $this yii\web\View */
/* @var $model app\models\Barang */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="barang-form">

    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

    <?= $form->field($model, 'kode_barang')->textInput(['maxlength' => true, 'readonly' => true, 'placeholder' => 'Otomatis akan diisi']) ?>

    <?= $form->field($model, 'nama')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'deskripsi')->textarea(['rows' => 6]) ?>

    <?php // Kategori moved above harga. Build options so we can attach data-id for edit/delete actions but keep the stored value as the category name ?>
    <div class="mb-3">
        <label class="form-label">Kategori</label>
        <select id="barang-kategori" class="form-select" name="Barang[kategori]">
            <option value="">-- Pilih Kategori --</option>
            <?php foreach (\app\models\Kategori::find()->all() as $k): ?>
                <option value="<?= Html::encode($k->nama) ?>" data-id="<?= $k->id ?>" <?= ($k->nama == $model->kategori) ? 'selected' : '' ?>><?= Html::encode($k->nama) ?></option>
            <?php endforeach; ?>
        </select>
        <div style="margin-top:6px">
            <div class="kategori-spoiler" style="display:inline-block;">
                <button type="button" id="kategori-toggle-btn" class="btn btn-sm btn-outline-info" aria-expanded="false">Kelola Kategori <span class="kategori-arrow">▾</span></button>
                <div id="kategori-actions" class="kategori-actions" aria-hidden="true">
                    <button type="button" id="kategori-add-btn" class="btn btn-sm btn-outline-primary">Tambah</button>
                    <button type="button" id="kategori-edit-btn" class="btn btn-sm btn-outline-secondary">Edit</button>
                    <button type="button" id="kategori-del-btn" class="btn btn-sm btn-outline-danger">Hapus</button>
                </div>
            </div>
        </div>
    </div>
                <style>
                /* Spoiler animation for kategori actions */
                #kategori-actions.kategori-actions {
                    display: inline-block;
                    margin-top: 6px;
                    margin-left: 6px;
                    max-height: 0;
                    overflow: hidden;
                    opacity: 0;
                    transform: translateY(-6px);
                    transition: max-height .28s ease, opacity .22s ease, transform .22s ease;
                }
                #kategori-actions.kategori-actions.open {
                    max-height: 160px;
                    opacity: 1;
                    transform: translateY(0);
                }
                .kategori-arrow {
                    display: inline-block;
                    margin-left: 6px;
                    transition: transform .22s ease;
                }
                #kategori-toggle-btn[aria-expanded="true"] .kategori-arrow {
                    transform: rotate(180deg);
                }
                </style>
                <script>
                (function(){
                    var btn = document.getElementById('kategori-toggle-btn');
                    var actions = document.getElementById('kategori-actions');
                    if (!btn || !actions) return;
                    btn.addEventListener('click', function(e){
                        var isOpen = actions.classList.contains('open');
                        if (isOpen) {
                            actions.classList.remove('open');
                            actions.setAttribute('aria-hidden', 'true');
                            btn.setAttribute('aria-expanded', 'false');
                        } else {
                            actions.classList.add('open');
                            actions.setAttribute('aria-hidden', 'false');
                            btn.setAttribute('aria-expanded', 'true');
                        }
                    });
                })();
                </script>

    <?php // Use a visible formatted input and a hidden raw numeric input for `harga` ?>
    <?= $form->field($model, 'harga')->hiddenInput(['id' => 'barang-harga'])->label(false) ?>
    <div class="mb-3">
        <label class="form-label">Harga</label>
        <input type="text" id="barang-harga-display" class="form-control currency-display" value="<?= ($model->harga !== null) ? 'Rp ' . number_format($model->harga, 0, ',', '.') : '' ?>">
        <?php if ($model->hasErrors('harga')): ?>
            <div class="invalid-feedback d-block"><?= Html::encode($model->getFirstError('harga')) ?></div>
        <?php endif; ?>
    </div>

    <?= $form->field($model, 'satuan')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'stok')->input('number') ?>

    <?php if (!empty($model->foto)): ?>
        <p>Current file: <?= Html::encode($model->foto) ?></p>
        <p><?= Html::img('@web/uploads/barang/thumbs/' . $model->foto, ['style'=>'max-width:200px;']) ?></p>
    <?php endif; ?>

    <?= $form->field($model, 'fotoFile')->fileInput(['accept' => 'image/*', 'onchange' => 'previewImage(event, "#barang-foto-preview")']) ?>
    <div id="barang-foto-preview" style="margin-top:8px;"></div>



    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Buat' : 'Simpan', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

    <?php $this->registerJsFile('@web/js/barang-form.js', ['depends' => [\yii\bootstrap5\BootstrapPluginAsset::class]]); ?>

<!-- Modal for kategori create/update -->
<div class="modal fade" id="kategoriModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Kategori</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="kategoriModalBody"></div>
        </div>
    </div>
</div>

