<?php  //[STAMP] d14fa592c5b8a5be1ae95bd505f50963
// phpcs:ignoreFile
namespace _generated;

// This class was automatically generated by build task
// You should not change it manually as it will be overwritten on next build

trait UnitTesterActions
{
    /**
     * @return \Codeception\Scenario
     */
    abstract protected function getScenario();

    
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Handles and checks throwables (Exceptions/Errors) called inside the callback function.
     * Either throwable class name or throwable instance should be provided.
     *
     * ```php
     * <?php
     * $I->expectThrowable(MyThrowable::class, function() {
     *     $this->doSomethingBad();
     * });
     *
     * $I->expectThrowable(new MyException(), function() {
     *     $this->doSomethingBad();
     * });
     * ```
     *
     * If you want to check message or throwable code, you can pass them with throwable instance:
     * ```php
     * <?php
     * // will check that throwable MyError is thrown with "Don't do bad things" message
     * $I->expectThrowable(new MyError("Don't do bad things"), function() {
     *     $this->doSomethingBad();
     * });
     * ```
     * @see \Codeception\Module\Asserts::expectThrowable()
     */
    public function expectThrowable(\Throwable|string $throwable, callable $callback): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('expectThrowable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file does not exist.
     * @see \Codeception\Module\AbstractAsserts::assertFileNotExists()
     */
    public function assertFileNotExists(string $filename, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileNotExists', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is greater than or equal to another value.
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertGreaterOrEquals()
     */
    public function assertGreaterOrEquals($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertGreaterOrEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is empty.
     *
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsEmpty()
     */
    public function assertIsEmpty($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsEmpty', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is smaller than or equal to another value.
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertLessOrEquals()
     */
    public function assertLessOrEquals($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertLessOrEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string does not match a given regular expression.
     * @see \Codeception\Module\AbstractAsserts::assertNotRegExp()
     */
    public function assertNotRegExp(string $pattern, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotRegExp', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string matches a given regular expression.
     * @see \Codeception\Module\AbstractAsserts::assertRegExp()
     */
    public function assertRegExp(string $pattern, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertRegExp', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Evaluates a PHPUnit\Framework\Constraint matcher object.
     *
     * @param mixed $value
     * @see \Codeception\Module\AbstractAsserts::assertThatItsNot()
     */
    public function assertThatItsNot($value, \PHPUnit\Framework\Constraint\Constraint $constraint, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertThatItsNot', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that an array has a specified key.
     *
     * @param int|string $key
     * @param array|\ArrayAccess $array
     * @see \Codeception\Module\AbstractAsserts::assertArrayHasKey()
     */
    public function assertArrayHasKey($key, $array, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertArrayHasKey', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that an array does not have a specified key.
     *
     * @param int|string $key
     * @param array|\ArrayAccess $array
     * @see \Codeception\Module\AbstractAsserts::assertArrayNotHasKey()
     */
    public function assertArrayNotHasKey($key, $array, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertArrayNotHasKey', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a class has a specified attribute.
     * @see \Codeception\Module\AbstractAsserts::assertClassHasAttribute()
     */
    public function assertClassHasAttribute(string $attributeName, string $className, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertClassHasAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a class has a specified static attribute.
     * @see \Codeception\Module\AbstractAsserts::assertClassHasStaticAttribute()
     */
    public function assertClassHasStaticAttribute(string $attributeName, string $className, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertClassHasStaticAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a class does not have a specified attribute.
     * @see \Codeception\Module\AbstractAsserts::assertClassNotHasAttribute()
     */
    public function assertClassNotHasAttribute(string $attributeName, string $className, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertClassNotHasAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a class does not have a specified static attribute.
     * @see \Codeception\Module\AbstractAsserts::assertClassNotHasStaticAttribute()
     */
    public function assertClassNotHasStaticAttribute(string $attributeName, string $className, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertClassNotHasStaticAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack contains a needle.
     *
     * @param mixed $needle
     * @see \Codeception\Module\AbstractAsserts::assertContains()
     */
    public function assertContains($needle, iterable $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertContains', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * @param mixed $needle
     * @see \Codeception\Module\AbstractAsserts::assertContainsEquals()
     */
    public function assertContainsEquals($needle, iterable $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertContainsEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack contains only values of a given type.
     * @see \Codeception\Module\AbstractAsserts::assertContainsOnly()
     */
    public function assertContainsOnly(string $type, iterable $haystack, ?bool $isNativeType = NULL, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertContainsOnly', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack contains only instances of a given class name.
     * @see \Codeception\Module\AbstractAsserts::assertContainsOnlyInstancesOf()
     */
    public function assertContainsOnlyInstancesOf(string $className, iterable $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertContainsOnlyInstancesOf', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts the number of elements of an array, Countable or Traversable.
     *
     * @param \Countable|iterable $haystack
     * @see \Codeception\Module\AbstractAsserts::assertCount()
     */
    public function assertCount(int $expectedCount, $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertCount', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory does not exist.
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryDoesNotExist()
     */
    public function assertDirectoryDoesNotExist(string $directory, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryDoesNotExist', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists.
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryExists()
     */
    public function assertDirectoryExists(string $directory, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryExists', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists and is not readable.
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryIsNotReadable()
     */
    public function assertDirectoryIsNotReadable(string $directory, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryIsNotReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists and is not writable.
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryIsNotWritable()
     */
    public function assertDirectoryIsNotWritable(string $directory, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryIsNotWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists and is readable.
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryIsReadable()
     */
    public function assertDirectoryIsReadable(string $directory, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryIsReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists and is writable.
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryIsWritable()
     */
    public function assertDirectoryIsWritable(string $directory, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryIsWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string does not match a given regular expression.
     * @see \Codeception\Module\AbstractAsserts::assertDoesNotMatchRegularExpression()
     */
    public function assertDoesNotMatchRegularExpression(string $pattern, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDoesNotMatchRegularExpression', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is empty.
     *
     * @param mixed $actual
     *
     * @phpstan-assert empty $actual
     * @see \Codeception\Module\AbstractAsserts::assertEmpty()
     */
    public function assertEmpty($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEmpty', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are equal.
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertEquals()
     */
    public function assertEquals($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are equal (canonicalizing).
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertEqualsCanonicalizing()
     */
    public function assertEqualsCanonicalizing($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEqualsCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are equal (ignoring case).
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertEqualsIgnoringCase()
     */
    public function assertEqualsIgnoringCase($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEqualsIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are equal (with delta).
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertEqualsWithDelta()
     */
    public function assertEqualsWithDelta($expected, $actual, float $delta, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEqualsWithDelta', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a condition is false.
     *
     * @param mixed $condition
     *
     * @phpstan-assert false $condition
     * @see \Codeception\Module\AbstractAsserts::assertFalse()
     */
    public function assertFalse($condition, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFalse', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file does not exist.
     * @see \Codeception\Module\AbstractAsserts::assertFileDoesNotExist()
     */
    public function assertFileDoesNotExist(string $filename, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileDoesNotExist', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is equal to the contents of another file.
     * @see \Codeception\Module\AbstractAsserts::assertFileEquals()
     */
    public function assertFileEquals(string $expected, string $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is equal to the contents of another file (canonicalizing).
     * @see \Codeception\Module\AbstractAsserts::assertFileEqualsCanonicalizing()
     */
    public function assertFileEqualsCanonicalizing(string $expected, string $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileEqualsCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is equal to the contents of another file (ignoring case).
     * @see \Codeception\Module\AbstractAsserts::assertFileEqualsIgnoringCase()
     */
    public function assertFileEqualsIgnoringCase(string $expected, string $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileEqualsIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists.
     * @see \Codeception\Module\AbstractAsserts::assertFileExists()
     */
    public function assertFileExists(string $filename, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileExists', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists and is not readable.
     * @see \Codeception\Module\AbstractAsserts::assertFileIsNotReadable()
     */
    public function assertFileIsNotReadable(string $file, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileIsNotReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists and is not writable.
     * @see \Codeception\Module\AbstractAsserts::assertFileIsNotWritable()
     */
    public function assertFileIsNotWritable(string $file, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileIsNotWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists and is readable.
     * @see \Codeception\Module\AbstractAsserts::assertFileIsReadable()
     */
    public function assertFileIsReadable(string $file, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileIsReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists and is writable.
     * @see \Codeception\Module\AbstractAsserts::assertFileIsWritable()
     */
    public function assertFileIsWritable(string $file, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileIsWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is not equal to the contents of another file.
     * @see \Codeception\Module\AbstractAsserts::assertFileNotEquals()
     */
    public function assertFileNotEquals(string $expected, string $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileNotEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is not equal to the contents of another file (canonicalizing).
     * @see \Codeception\Module\AbstractAsserts::assertFileNotEqualsCanonicalizing()
     */
    public function assertFileNotEqualsCanonicalizing(string $expected, string $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileNotEqualsCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is not equal to the contents of another file (ignoring case).
     * @see \Codeception\Module\AbstractAsserts::assertFileNotEqualsIgnoringCase()
     */
    public function assertFileNotEqualsIgnoringCase(string $expected, string $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileNotEqualsIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is finite.
     *
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertFinite()
     */
    public function assertFinite($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFinite', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is greater than another value.
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertGreaterThan()
     */
    public function assertGreaterThan($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertGreaterThan', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is greater than or equal to another value.
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertGreaterThanOrEqual()
     */
    public function assertGreaterThanOrEqual($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertGreaterThanOrEqual', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is infinite.
     *
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertInfinite()
     */
    public function assertInfinite($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertInfinite', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of a given type.
     *
     * @template ExpectedType of object
     *
     * @param mixed $actual
     * @param class-string<ExpectedType> $expected
     *
     * @phpstan-assert =ExpectedType $actual
     * @see \Codeception\Module\AbstractAsserts::assertInstanceOf()
     */
    public function assertInstanceOf(string $expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertInstanceOf', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type array.
     *
     * @param mixed $actual
     *
     * @phpstan-assert array $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsArray()
     */
    public function assertIsArray($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsArray', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type bool.
     *
     * @param mixed $actual
     *
     * @phpstan-assert bool $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsBool()
     */
    public function assertIsBool($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsBool', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type callable.
     *
     * @param mixed $actual
     *
     * @phpstan-assert callable $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsCallable()
     */
    public function assertIsCallable($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsCallable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type resource and is closed.
     *
     * @param mixed $actual
     *
     * @phpstan-assert resource $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsClosedResource()
     */
    public function assertIsClosedResource($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsClosedResource', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type float.
     *
     * @param mixed $actual
     *
     * @phpstan-assert float $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsFloat()
     */
    public function assertIsFloat($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsFloat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type int.
     *
     * @param mixed $actual
     *
     * @phpstan-assert int $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsInt()
     */
    public function assertIsInt($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsInt', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type iterable.
     *
     * @param mixed $actual
     *
     * @phpstan-assert iterable $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsIterable()
     */
    public function assertIsIterable($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsIterable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type array.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !array $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotArray()
     */
    public function assertIsNotArray($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotArray', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type bool.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !bool $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotBool()
     */
    public function assertIsNotBool($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotBool', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type callable.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !callable $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotCallable()
     */
    public function assertIsNotCallable($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotCallable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type resource.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !resource $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotClosedResource()
     */
    public function assertIsNotClosedResource($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotClosedResource', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type float.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !float $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotFloat()
     */
    public function assertIsNotFloat($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotFloat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type int.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !int $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotInt()
     */
    public function assertIsNotInt($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotInt', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type iterable.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !iterable $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotIterable()
     */
    public function assertIsNotIterable($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotIterable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type numeric.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !numeric $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotNumeric()
     */
    public function assertIsNotNumeric($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotNumeric', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type object.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !object $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotObject()
     */
    public function assertIsNotObject($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotObject', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file/dir exists and is not readable.
     * @see \Codeception\Module\AbstractAsserts::assertIsNotReadable()
     */
    public function assertIsNotReadable(string $filename, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type resource.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !resource $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotResource()
     */
    public function assertIsNotResource($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotResource', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type scalar.
     *
     * @param mixed $actual
     *
     * @psalm-assert !scalar $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotScalar()
     */
    public function assertIsNotScalar($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotScalar', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type string.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !string $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNotString()
     */
    public function assertIsNotString($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file/dir exists and is not writable.
     * @see \Codeception\Module\AbstractAsserts::assertIsNotWritable()
     */
    public function assertIsNotWritable(string $filename, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type numeric.
     *
     * @param mixed $actual
     *
     * @phpstan-assert numeric $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsNumeric()
     */
    public function assertIsNumeric($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNumeric', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type object.
     *
     * @param mixed $actual
     *
     * @phpstan-assert object $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsObject()
     */
    public function assertIsObject($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsObject', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file/dir is readable.
     * @see \Codeception\Module\AbstractAsserts::assertIsReadable()
     */
    public function assertIsReadable(string $filename, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type resource.
     *
     * @param mixed $actual
     *
     * @phpstan-assert resource $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsResource()
     */
    public function assertIsResource($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsResource', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type scalar.
     *
     * @param mixed $actual
     *
     * @phpstan-assert scalar $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsScalar()
     */
    public function assertIsScalar($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsScalar', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type string.
     *
     * @param mixed $actual
     *
     * @phpstan-assert string $actual
     * @see \Codeception\Module\AbstractAsserts::assertIsString()
     */
    public function assertIsString($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file/dir exists and is writable.
     * @see \Codeception\Module\AbstractAsserts::assertIsWritable()
     */
    public function assertIsWritable(string $filename, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string is a valid JSON string.
     * @see \Codeception\Module\AbstractAsserts::assertJson()
     */
    public function assertJson(string $actualJson, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJson', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two JSON files are equal.
     * @see \Codeception\Module\AbstractAsserts::assertJsonFileEqualsJsonFile()
     */
    public function assertJsonFileEqualsJsonFile(string $expectedFile, string $actualFile, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonFileEqualsJsonFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two JSON files are not equal.
     * @see \Codeception\Module\AbstractAsserts::assertJsonFileNotEqualsJsonFile()
     */
    public function assertJsonFileNotEqualsJsonFile(string $expectedFile, string $actualFile, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonFileNotEqualsJsonFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the generated JSON encoded object and the content of the given file are equal.
     * @see \Codeception\Module\AbstractAsserts::assertJsonStringEqualsJsonFile()
     */
    public function assertJsonStringEqualsJsonFile(string $expectedFile, string $actualJson, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonStringEqualsJsonFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two given JSON encoded objects or arrays are equal.
     * @see \Codeception\Module\AbstractAsserts::assertJsonStringEqualsJsonString()
     */
    public function assertJsonStringEqualsJsonString(string $expectedJson, string $actualJson, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonStringEqualsJsonString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the generated JSON encoded object and the content of the given file are not equal.
     * @see \Codeception\Module\AbstractAsserts::assertJsonStringNotEqualsJsonFile()
     */
    public function assertJsonStringNotEqualsJsonFile(string $expectedFile, string $actualJson, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonStringNotEqualsJsonFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two given JSON encoded objects or arrays are not equal.
     * @see \Codeception\Module\AbstractAsserts::assertJsonStringNotEqualsJsonString()
     */
    public function assertJsonStringNotEqualsJsonString(string $expectedJson, string $actualJson, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonStringNotEqualsJsonString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is smaller than another value.
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertLessThan()
     */
    public function assertLessThan($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertLessThan', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is smaller than or equal to another value.
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertLessThanOrEqual()
     */
    public function assertLessThanOrEqual($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertLessThanOrEqual', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string matches a given regular expression.
     * @see \Codeception\Module\AbstractAsserts::assertMatchesRegularExpression()
     */
    public function assertMatchesRegularExpression(string $pattern, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertMatchesRegularExpression', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is nan.
     *
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertNan()
     */
    public function assertNan($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNan', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack does not contain a needle.
     *
     * @param mixed $needle
     * @see \Codeception\Module\AbstractAsserts::assertNotContains()
     */
    public function assertNotContains($needle, iterable $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotContains', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     *
     * @see \Codeception\Module\AbstractAsserts::assertNotContainsEquals()
     */
    public function assertNotContainsEquals($needle, iterable $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotContainsEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack does not contain only values of a given type.
     * @see \Codeception\Module\AbstractAsserts::assertNotContainsOnly()
     */
    public function assertNotContainsOnly(string $type, iterable $haystack, ?bool $isNativeType = NULL, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotContainsOnly', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts the number of elements of an array, Countable or Traversable.
     *
     * @param \Countable|iterable $haystack
     * @see \Codeception\Module\AbstractAsserts::assertNotCount()
     */
    public function assertNotCount(int $expectedCount, $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotCount', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not empty.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !empty $actual
     * @see \Codeception\Module\AbstractAsserts::assertNotEmpty()
     */
    public function assertNotEmpty($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEmpty', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are not equal.
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertNotEquals()
     */
    public function assertNotEquals($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are not equal (canonicalizing).
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertNotEqualsCanonicalizing()
     */
    public function assertNotEqualsCanonicalizing($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEqualsCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are not equal (ignoring case).
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertNotEqualsIgnoringCase()
     */
    public function assertNotEqualsIgnoringCase($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEqualsIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are not equal (with delta).
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertNotEqualsWithDelta()
     */
    public function assertNotEqualsWithDelta($expected, $actual, float $delta, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEqualsWithDelta', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a condition is not false.
     *
     * @param mixed $condition
     *
     * @phpstan-assert !false $condition
     * @see \Codeception\Module\AbstractAsserts::assertNotFalse()
     */
    public function assertNotFalse($condition, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotFalse', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of a given type.
     *
     * @template ExpectedType of object
     *
     * @param mixed $actual
     * @param class-string<ExpectedType> $expected
     *
     * @phpstan-assert !ExpectedType $actual
     * @see \Codeception\Module\AbstractAsserts::assertNotInstanceOf()
     */
    public function assertNotInstanceOf(string $expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotInstanceOf', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not null.
     *
     * @param mixed $actual
     *
     * @phpstan-assert !null $actual
     * @see \Codeception\Module\AbstractAsserts::assertNotNull()
     */
    public function assertNotNull($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotNull', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables do not have the same type and value.
     *
     * @param mixed $expected
     * @param mixed $actual
     * @see \Codeception\Module\AbstractAsserts::assertNotSame()
     */
    public function assertNotSame($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotSame', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Assert that the size of two arrays (or `Countable` or `Traversable` objects) is not the same.
     *
     * @param \Countable|iterable $expected
     * @param \Countable|iterable $actual
     * @see \Codeception\Module\AbstractAsserts::assertNotSameSize()
     */
    public function assertNotSameSize($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotSameSize', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a condition is not true.
     *
     * @param mixed $condition
     *
     * @phpstan-assert !true $condition
     * @see \Codeception\Module\AbstractAsserts::assertNotTrue()
     */
    public function assertNotTrue($condition, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotTrue', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is null.
     *
     * @param mixed $actual
     *
     * @phpstan-assert null $actual
     * @see \Codeception\Module\AbstractAsserts::assertNull()
     */
    public function assertNull($actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNull', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that an object has a specified attribute.
     * @see \Codeception\Module\AbstractAsserts::assertObjectHasAttribute()
     */
    public function assertObjectHasAttribute(string $attributeName, object $object, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertObjectHasAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that an object does not have a specified attribute.
     * @see \Codeception\Module\AbstractAsserts::assertObjectNotHasAttribute()
     */
    public function assertObjectNotHasAttribute(string $attributeName, object $object, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertObjectNotHasAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables have the same type and value.
     * Used on objects, it asserts that two variables reference
     * the same object.
     *
     * @template ExpectedType
     *
     * @param ExpectedType $expected
     * @param mixed $actual
     *
     * @phpstan-assert =ExpectedType $actual
     * @see \Codeception\Module\AbstractAsserts::assertSame()
     */
    public function assertSame($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertSame', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Assert that the size of two arrays (or `Countable` or `Traversable` objects) is the same.
     *
     * @param \Countable|iterable $expected
     * @param \Countable|iterable $actual
     * @see \Codeception\Module\AbstractAsserts::assertSameSize()
     */
    public function assertSameSize($expected, $actual, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertSameSize', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     *
     * @see \Codeception\Module\AbstractAsserts::assertStringContainsString()
     */
    public function assertStringContainsString(string $needle, string $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringContainsString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     *
     * @see \Codeception\Module\AbstractAsserts::assertStringContainsStringIgnoringCase()
     */
    public function assertStringContainsStringIgnoringCase(string $needle, string $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringContainsStringIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string ends not with a given suffix.
     * @see \Codeception\Module\AbstractAsserts::assertStringEndsNotWith()
     */
    public function assertStringEndsNotWith(string $suffix, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEndsNotWith', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string ends with a given suffix.
     * @see \Codeception\Module\AbstractAsserts::assertStringEndsWith()
     */
    public function assertStringEndsWith(string $suffix, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEndsWith', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is equal to the contents of a file.
     * @see \Codeception\Module\AbstractAsserts::assertStringEqualsFile()
     */
    public function assertStringEqualsFile(string $expectedFile, string $actualString, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEqualsFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is equal to the contents of a file (canonicalizing).
     * @see \Codeception\Module\AbstractAsserts::assertStringEqualsFileCanonicalizing()
     */
    public function assertStringEqualsFileCanonicalizing(string $expectedFile, string $actualString, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEqualsFileCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is equal to the contents of a file (ignoring case).
     * @see \Codeception\Module\AbstractAsserts::assertStringEqualsFileIgnoringCase()
     */
    public function assertStringEqualsFileIgnoringCase(string $expectedFile, string $actualString, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEqualsFileIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string matches a given format string.
     * @see \Codeception\Module\AbstractAsserts::assertStringMatchesFormat()
     */
    public function assertStringMatchesFormat(string $format, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringMatchesFormat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string matches a given format file.
     * @see \Codeception\Module\AbstractAsserts::assertStringMatchesFormatFile()
     */
    public function assertStringMatchesFormatFile(string $formatFile, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringMatchesFormatFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     *
     * @see \Codeception\Module\AbstractAsserts::assertStringNotContainsString()
     */
    public function assertStringNotContainsString(string $needle, string $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotContainsString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     *
     * @see \Codeception\Module\AbstractAsserts::assertStringNotContainsStringIgnoringCase()
     */
    public function assertStringNotContainsStringIgnoringCase(string $needle, string $haystack, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotContainsStringIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is not equal to the contents of a file.
     * @see \Codeception\Module\AbstractAsserts::assertStringNotEqualsFile()
     */
    public function assertStringNotEqualsFile(string $expectedFile, string $actualString, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotEqualsFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is not equal to the contents of a file (canonicalizing).
     * @see \Codeception\Module\AbstractAsserts::assertStringNotEqualsFileCanonicalizing()
     */
    public function assertStringNotEqualsFileCanonicalizing(string $expectedFile, string $actualString, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotEqualsFileCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is not equal to the contents of a file (ignoring case).
     * @see \Codeception\Module\AbstractAsserts::assertStringNotEqualsFileIgnoringCase()
     */
    public function assertStringNotEqualsFileIgnoringCase(string $expectedFile, string $actualString, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotEqualsFileIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string does not match a given format string.
     * @see \Codeception\Module\AbstractAsserts::assertStringNotMatchesFormat()
     */
    public function assertStringNotMatchesFormat(string $format, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotMatchesFormat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string does not match a given format string.
     * @see \Codeception\Module\AbstractAsserts::assertStringNotMatchesFormatFile()
     */
    public function assertStringNotMatchesFormatFile(string $formatFile, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotMatchesFormatFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string starts not with a given prefix.
     * @see \Codeception\Module\AbstractAsserts::assertStringStartsNotWith()
     */
    public function assertStringStartsNotWith(string $prefix, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringStartsNotWith', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string starts with a given prefix.
     * @see \Codeception\Module\AbstractAsserts::assertStringStartsWith()
     */
    public function assertStringStartsWith(string $prefix, string $string, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringStartsWith', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Evaluates a PHPUnit\Framework\Constraint matcher object.
     *
     * @param mixed $value
     * @see \Codeception\Module\AbstractAsserts::assertThat()
     */
    public function assertThat($value, \PHPUnit\Framework\Constraint\Constraint $constraint, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertThat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a condition is true.
     *
     * @param mixed $condition
     *
     * @phpstan-assert true $condition
     * @see \Codeception\Module\AbstractAsserts::assertTrue()
     */
    public function assertTrue($condition, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertTrue', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML files are equal.
     * @see \Codeception\Module\AbstractAsserts::assertXmlFileEqualsXmlFile()
     */
    public function assertXmlFileEqualsXmlFile(string $expectedFile, string $actualFile, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlFileEqualsXmlFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML files are not equal.
     * @see \Codeception\Module\AbstractAsserts::assertXmlFileNotEqualsXmlFile()
     */
    public function assertXmlFileNotEqualsXmlFile(string $expectedFile, string $actualFile, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlFileNotEqualsXmlFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML documents are equal.
     *
     * @param \DOMDocument|string $actualXml
     * @see \Codeception\Module\AbstractAsserts::assertXmlStringEqualsXmlFile()
     */
    public function assertXmlStringEqualsXmlFile(string $expectedFile, $actualXml, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlStringEqualsXmlFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML documents are equal.
     *
     * @param \DOMDocument|string $expectedXml
     * @param \DOMDocument|string $actualXml
     * @see \Codeception\Module\AbstractAsserts::assertXmlStringEqualsXmlString()
     */
    public function assertXmlStringEqualsXmlString($expectedXml, $actualXml, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlStringEqualsXmlString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML documents are not equal.
     *
     * @param \DOMDocument|string $actualXml
     * @see \Codeception\Module\AbstractAsserts::assertXmlStringNotEqualsXmlFile()
     */
    public function assertXmlStringNotEqualsXmlFile(string $expectedFile, $actualXml, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlStringNotEqualsXmlFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML documents are not equal.
     *
     * @param \DOMDocument|string $expectedXml
     * @param \DOMDocument|string $actualXml
     * @see \Codeception\Module\AbstractAsserts::assertXmlStringNotEqualsXmlString()
     */
    public function assertXmlStringNotEqualsXmlString($expectedXml, $actualXml, string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlStringNotEqualsXmlString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Fails a test with the given message.
     * @see \Codeception\Module\AbstractAsserts::fail()
     */
    public function fail(string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('fail', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Mark the test as incomplete.
     * @see \Codeception\Module\AbstractAsserts::markTestIncomplete()
     */
    public function markTestIncomplete(string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('markTestIncomplete', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Mark the test as skipped.
     * @see \Codeception\Module\AbstractAsserts::markTestSkipped()
     */
    public function markTestSkipped(string $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('markTestSkipped', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Creates and loads fixtures from a config.
     * The signature is the same as for the `fixtures()` method of `yii\test\FixtureTrait`
     *
     * ```php
     * <?php
     * $I->haveFixtures([
     *     'posts' => PostsFixture::class,
     *     'user' => [
     *         'class' => UserFixture::class,
     *         'dataFile' => '@tests/_data/models/user.php',
     *      ],
     * ]);
     * ```
     *
     * Note: if you need to load fixtures before a test (probably before the
     * cleanup transaction is started; `cleanup` option is `true` by default),
     * you can specify the fixtures in the `_fixtures()` method of a test case
     *
     * ```php
     * <?php
     * // inside Cest file or Codeception\TestCase\Unit
     * public function _fixtures(){
     *     return [
     *         'user' => [
     *             'class' => UserFixture::class,
     *             'dataFile' => codecept_data_dir() . 'user.php'
     *         ]
     *     ];
     * }
     * ```
     * instead of calling `haveFixtures` in Cest `_before`
     *
     * @param $fixtures
     * @part fixtures
     * @see \Codeception\Module\Yii2::haveFixtures()
     */
    public function haveFixtures($fixtures): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('haveFixtures', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Returns all loaded fixtures.
     * Array of fixture instances
     *
     * @part fixtures
     * @return array
     * @see \Codeception\Module\Yii2::grabFixtures()
     */
    public function grabFixtures() {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabFixtures', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Gets a fixture by name.
     * Returns a Fixture instance. If a fixture is an instance of
     * `\yii\test\BaseActiveFixture` a second parameter can be used to return a
     * specific model:
     *
     * ```php
     * <?php
     * $I->haveFixtures(['users' => UserFixture::class]);
     *
     * $users = $I->grabFixture('users');
     *
     * // get first user by key, if a fixture is an instance of ActiveFixture
     * $user = $I->grabFixture('users', 'user1');
     * ```
     *
     * @param $name
     * @return mixed
     * @throws \Codeception\Exception\ModuleException if the fixture is not found
     * @part fixtures
     * @see \Codeception\Module\Yii2::grabFixture()
     */
    public function grabFixture($name, $index = NULL) {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabFixture', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Inserts a record into the database.
     *
     * ``` php
     * <?php
     * $user_id = $I->haveRecord('app\models\User', array('name' => 'Davert'));
     * ?>
     * ```
     * @template T of \yii\db\ActiveRecord
     * @param class-string<T> $model
     * @param array<string, mixed> $attributes
     * @return mixed
     * @part orm
     * @see \Codeception\Module\Yii2::haveRecord()
     */
    public function haveRecord(string $model, $attributes = []): mixed {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('haveRecord', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that a record exists in the database.
     *
     * ``` php
     * $I->seeRecord('app\models\User', array('name' => 'davert'));
     * ```
     *
     * @param class-string<\yii\db\ActiveRecord> $model
     * @param array<string, mixed> $attributes
     * @part orm
     * @see \Codeception\Module\Yii2::seeRecord()
     */
    public function seeRecord(string $model, array $attributes = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeRecord', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that a record exists in the database.
     *
     * ``` php
     * $I->seeRecord('app\models\User', array('name' => 'davert'));
     * ```
     *
     * @param class-string<\yii\db\ActiveRecord> $model
     * @param array<string, mixed> $attributes
     * @part orm
     * @see \Codeception\Module\Yii2::seeRecord()
     */
    public function canSeeRecord(string $model, array $attributes = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeRecord', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that a record does not exist in the database.
     *
     * ``` php
     * $I->dontSeeRecord('app\models\User', array('name' => 'davert'));
     * ```
     *
     * @param class-string<\yii\db\ActiveRecord> $model
     * @param array<string, mixed> $attributes
     * @part orm
     * @see \Codeception\Module\Yii2::dontSeeRecord()
     */
    public function dontSeeRecord(string $model, array $attributes = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeRecord', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that a record does not exist in the database.
     *
     * ``` php
     * $I->dontSeeRecord('app\models\User', array('name' => 'davert'));
     * ```
     *
     * @param class-string<\yii\db\ActiveRecord> $model
     * @param array<string, mixed> $attributes
     * @part orm
     * @see \Codeception\Module\Yii2::dontSeeRecord()
     */
    public function cantSeeRecord(string $model, array $attributes = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeRecord', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Retrieves a record from the database
     *
     * ``` php
     * $category = $I->grabRecord('app\models\User', array('name' => 'davert'));
     * ```
     *
     * @param class-string<\yii\db\ActiveRecord> $model
     * @param array<string, mixed> $attributes
     * @part orm
     * @see \Codeception\Module\Yii2::grabRecord()
     */
    public function grabRecord(string $model, array $attributes = []): \yii\db\ActiveRecord|array|null {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabRecord', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that an email is sent.
     *
     * ```php
     * <?php
     * // check that at least 1 email was sent
     * $I->seeEmailIsSent();
     *
     * // check that only 3 emails were sent
     * $I->seeEmailIsSent(3);
     * ```
     *
     * @param int|null $num
     * @throws \Codeception\Exception\ModuleException
     * @part email
     * @see \Codeception\Module\Yii2::seeEmailIsSent()
     */
    public function seeEmailIsSent(?int $num = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeEmailIsSent', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that an email is sent.
     *
     * ```php
     * <?php
     * // check that at least 1 email was sent
     * $I->seeEmailIsSent();
     *
     * // check that only 3 emails were sent
     * $I->seeEmailIsSent(3);
     * ```
     *
     * @param int|null $num
     * @throws \Codeception\Exception\ModuleException
     * @part email
     * @see \Codeception\Module\Yii2::seeEmailIsSent()
     */
    public function canSeeEmailIsSent(?int $num = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeEmailIsSent', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that no email was sent
     *
     * @part email
     * @see \Codeception\Module\Yii2::dontSeeEmailIsSent()
     */
    public function dontSeeEmailIsSent(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeEmailIsSent', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that no email was sent
     *
     * @part email
     * @see \Codeception\Module\Yii2::dontSeeEmailIsSent()
     */
    public function cantSeeEmailIsSent(): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeEmailIsSent', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Returns array of all sent email messages.
     * Each message implements the `yii\mail\MessageInterface` interface.
     * Useful to perform additional checks using the `Asserts` module:
     *
     * ```php
     * <?php
     * $I->seeEmailIsSent();
     * $messages = $I->grabSentEmails();
     * $I->assertEquals('admin@site,com', $messages[0]->getTo());
     * ```
     *
     * @part email
     * @return array
     * @throws \Codeception\Exception\ModuleException
     * @see \Codeception\Module\Yii2::grabSentEmails()
     */
    public function grabSentEmails(): array {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabSentEmails', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Returns the last sent email:
     *
     * ```php
     * <?php
     * $I->seeEmailIsSent();
     * $message = $I->grabLastSentEmail();
     * $I->assertEquals('admin@site,com', $message->getTo());
     * ```
     * @part email
     * @see \Codeception\Module\Yii2::grabLastSentEmail()
     */
    public function grabLastSentEmail(): object {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabLastSentEmail', func_get_args()));
    }
}
