<?php
// Simple script to create sample pelanggan, barang and a kontrak for testing
chdir(__DIR__ . '/..');
require __DIR__ . '/../vendor/autoload.php';
require __DIR__ . '/../vendor/yiisoft/yii2/Yii.php';

// use console config to avoid web asset manager side-effects when bootstrapping
$config = require __DIR__ . '/../config/console.php';
$app = new \yii\console\Application($config);

use app\models\Pelanggan;
use app\models\Barang;
use app\models\Setting;
use app\models\Kontrak;
use app\models\KontrakItem;
use app\models\KontrakInstallment;

echo "Creating sample data...\n";

// create pelanggan
$pel = new Pelanggan();
$pel->nama = 'Test Pelanggan';
$pel->no_ktp = '1234567890123456';
$pel->no_whatsapp = '081234567890';
$pel->kode_pelanggan = $pel->generateKode();
$pel->created_at = date('Y-m-d H:i:s');
if (!$pel->save()) {
    echo "Failed to save pelanggan: "; print_r($pel->getErrors()); exit(1);
}
// determine primary key value
$pelPk = $pel->getPrimaryKey();
echo "Pelanggan created pk=".print_r($pelPk,true)."\n";

// create barang if none exists
$barang = Barang::find()->one();
if (!$barang) {
    $b = new Barang();
    $b->nama = 'Test Barang A';
    $b->deskripsi = 'Contoh barang untuk kontrak';
    $b->harga = 250000;
    $b->kode_barang = $b->generateKode();
    if (!$b->save()) { echo "Failed to save barang: "; print_r($b->getErrors()); exit(1); }
    $barang = $b;
    echo "Barang created id=".print_r($barang->getPrimaryKey(),true)."\n";
} else {
    echo "Using existing barang pk=".print_r($barang->getPrimaryKey(),true)."\n";
}

// prepare kontrak
$prefix = Setting::get('kontrak_prefix','KTR');
$today = date('Ymd');
$seqKey = 'kontrak_seq_'.$today;
$seq = intval(Setting::get($seqKey,0)) + 1;
Setting::set($seqKey,$seq);
$nomor = sprintf('%s-%s-%04d', $prefix, date('ymd'), $seq);

$kontrak = new Kontrak();
$kontrak->nomor = $nomor;
$pelPkVal = $pel->getPrimaryKey();
// only use pelanggan PK if numeric; else set 0 and warn
$kontrak->pelanggan_id = $pel->kode_pelanggan;
$kontrak->tanggal_mulai = date('Y-m-d');
$kontrak->dp = 50000;
$kontrak->margin_per_week = 2.0;
$kontrak->tenor = 10;
$kontrak->tenor_unit = 'week';
$kontrak->total_harga = $barang->harga;
$kontrak->is_custom_installment = 0;
$kontrak->created_at = date('Y-m-d H:i:s');
if (!$kontrak->save()) { echo "Failed to save kontrak: "; print_r($kontrak->getErrors()); exit(1); }
echo "Kontrak created id={$kontrak->id} nomor={$kontrak->nomor}\n";

$ki = new KontrakItem();
$ki->kontrak_id = $kontrak->id;
$ki->barang_id = $barang->kode_barang;
$ki->qty = 1;
$ki->harga = $barang->harga;
$ki->save(false);

// create installments
$remaining = $kontrak->total_harga - $kontrak->dp;
$tenor_weeks = $kontrak->tenor;
$total_with_interest = $remaining + ($remaining * ($kontrak->margin_per_week/100.0) * $tenor_weeks);
$raw = $total_with_interest / $kontrak->tenor;
$rounded = round($raw/1000)*1000;
for ($p=1;$p<=$kontrak->tenor;$p++){
    $dt = new DateTime($kontrak->tanggal_mulai);
    $dt->add(new DateInterval('P'.($p).'W'));
    $ins = new KontrakInstallment();
    $ins->kontrak_id = $kontrak->id;
    $ins->periode = $p;
    $ins->due_date = $dt->format('Y-m-d');
    $ins->amount = $rounded;
    $ins->paid = 0;
    $ins->save(false);
}

echo "Installments created: {$kontrak->tenor}\n";
echo "Done. Open kontrak list or print pages to verify.\n";
