<?php
// Usage: php show_pembayaran_items_for_kontrak.php <kontrak_id>
$argv = $_SERVER['argv'];
$kontrakId = isset($argv[1]) ? intval($argv[1]) : 0;
if (!$kontrakId) {
    echo "Usage: php show_pembayaran_items_for_kontrak.php <kontrak_id>\n";
    exit(1);
}

$dbConfig = require __DIR__ . '/../config/db.php';
$dsn = $dbConfig['dsn'];
preg_match('/host=([^;]+);dbname=([^;]+)/', $dsn, $m);
$host = $m[1] ?? '127.0.0.1';
$dbname = $m[2] ?? 'cicilan';
$user = $dbConfig['username'] ?? 'root';
$pass = $dbConfig['password'] ?? '';

$mysqli = new mysqli($host, $user, $pass, $dbname);
if ($mysqli->connect_errno) {
    echo "DB connect error: " . $mysqli->connect_error . "\n";
    exit(1);
}
$mysqli->set_charset('utf8mb4');

$sql = "SELECT k.id as installment_id, k.periode, k.due_date, k.amount as installment_amount,
pitem.id as pembayaran_item_id, pitem.pembayaran_id, pitem.amount as paid_amount, pitem.paid_at, p.nomor as pembayaran_nomor
FROM kontrak_installment k
LEFT JOIN pembayaran_item pitem ON pitem.kontrak_installment_id = k.id
LEFT JOIN pembayaran p ON p.id = pitem.pembayaran_id
WHERE k.kontrak_id = " . intval($kontrakId) . "
ORDER BY k.periode ASC, pitem.paid_at ASC";

$res = $mysqli->query($sql);
if (!$res) {
    echo "Query error: " . $mysqli->error . "\n";
    exit(1);
}

$currentPeriode = null;
while ($row = $res->fetch_assoc()) {
    if ($currentPeriode !== $row['periode']) {
        echo "\nPeriode: " . $row['periode'] . " | Due: " . $row['due_date'] . " | Amount: " . number_format($row['installment_amount'],0,',','.') . "\n";
        $currentPeriode = $row['periode'];
    }
    if ($row['pembayaran_item_id']) {
        printf("  item_id:%s pembayaran_id:%s pembayaran_nomor:%s paid_at:%s amount:%s\n",
            $row['pembayaran_item_id'],$row['pembayaran_id'],$row['pembayaran_nomor'],$row['paid_at'],number_format($row['paid_amount'],0,',','.')
        );
    } else {
        echo "  (belum ada pembayaran untuk periode ini)\n";
    }
}

$mysqli->close();
