<?php
// Simple script to show last pembayaran and its items
$dbConfig = require __DIR__ . '/../config/db.php';
$dsn = $dbConfig['dsn'];
// parse dsn mysql:host=...;dbname=...
preg_match('/host=([^;]+);dbname=([^;]+)/', $dsn, $m);
$host = $m[1] ?? '127.0.0.1';
 $dbname = $m[2] ?? 'cicilan';
$user = $dbConfig['username'] ?? 'root';
$pass = $dbConfig['password'] ?? '';

$mysqli = new mysqli($host, $user, $pass, $dbname);
if ($mysqli->connect_errno) {
    echo "DB connect error: " . $mysqli->connect_error . "\n";
    exit(1);
}

$mysqli->set_charset('utf8mb4');

$res = $mysqli->query("SELECT * FROM pembayaran ORDER BY id DESC LIMIT 1");
if (!$res) {
    echo "Query error: " . $mysqli->error . "\n";
    exit(1);
}
$p = $res->fetch_assoc();
if (!$p) {
    echo "No pembayaran found\n";
    exit(0);
}

echo "Pembayaran (last)\n";
foreach ($p as $k=>$v) echo "$k: $v\n";

echo "\nPembayaran items:\n";
$pid = intval($p['id']);
$ri = $mysqli->query("SELECT * FROM pembayaran_item WHERE pembayaran_id = $pid ORDER BY id ASC");
while ($row = $ri->fetch_assoc()) {
    echo "---\n";
    foreach ($row as $k=>$v) echo "$k: $v\n";
}

$mysqli->close();
