<?php
require __DIR__ . '/../../vendor/autoload.php';
$config = require __DIR__ . '/../../config/db.php';
$dsn = $config['dsn'];
// parse dsn mysql:host=...;dbname=...
preg_match('/mysql:host=([^;]+);dbname=([^;]+)/', $dsn, $m);
$host = $m[1] ?? '127.0.0.1';
$db = $m[2] ?? '';
$user = $config['username'] ?? 'root';
$pass = $config['password'] ?? '';
$mysqli = new mysqli($host, $user, $pass, $db);
if ($mysqli->connect_errno) {
    echo "DB connect error: " . $mysqli->connect_error . PHP_EOL;
    exit(1);
}
$result = $mysqli->query("SELECT id, name, description FROM permission ORDER BY name LIMIT 200");
if (!$result) {
    echo "Query error: " . $mysqli->error . PHP_EOL;
    exit(1);
}
$rows = [];
while ($r = $result->fetch_assoc()) $rows[] = $r;
if (empty($rows)) {
    echo "permission table empty\n";
    exit(0);
}
foreach ($rows as $row) {
    printf("%3s  %-30s  %s\n", $row['id'], $row['name'], $row['description']);
}
$mysqli->close();
