<?php
$base = $argv[1] ?? 'http://localhost/cicilan/web/index.php?r=';
$loginUrl = preg_replace('/\?r=.*$/', '', $base) . '?r=site/login';
$routes = [
    'site/index', 'site/login',
    'barang/index', 'barang/create',
    'pelanggan/index', 'pelanggan/create',
    'kategori/index',
    'kontrak/index', 'kontrak/create',
    'pembayaran/index', 'pembayaran/create',
    'setting/index', 'setting/user', 'setting/prefix',
    'role/index', 'permission/index', 'user/index'
];
$cookie = sys_get_temp_dir() . DIRECTORY_SEPARATOR . 'cicilan_cookie.txt';
if (file_exists($cookie)) unlink($cookie);

// 1) GET login page to get CSRF
$ch = curl_init($loginUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie);
$loginPage = curl_exec($ch);
if ($loginPage === false) { echo "Failed to GET login page: " . curl_error($ch) . PHP_EOL; exit(1); }

// try to get CSRF from hidden input or meta tag
$csrf = null;
if (preg_match('/name="_csrf" value="([^"]+)"/', $loginPage, $m)) {
    $csrf = $m[1];
} elseif (preg_match('/meta name="csrf-token" content="([^"]+)"/', $loginPage, $m)) {
    $csrf = $m[1];
}

if (!$csrf) {
    // try cookie value
    $cookies = file_get_contents($cookie);
    if (preg_match('/_csrf\t([^\n\r]+)/', $cookies, $m)) {
        $csrf = trim($m[1]);
    }
}

if (!$csrf) { echo "Warning: CSRF token not found; login may fail\n"; }

// 2) POST login
$postFields = [
    'LoginForm[username]' => 'admin',
    'LoginForm[password]' => 'admin',
    'LoginForm[rememberMe]' => '0',
];
if ($csrf) $postFields['_csrf'] = $csrf;

$ch = curl_init($loginUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie);
curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postFields));
$resp = curl_exec($ch);
if ($resp === false) { echo "Login POST failed: " . curl_error($ch) . PHP_EOL; exit(1); }
$info = curl_getinfo($ch);
echo "LOGIN HTTP: " . $info['http_code'] . PHP_EOL;
// detect successful login by redirect or presence of logout link
$logged = false;
if ($info['http_code'] >= 300 && $info['http_code'] < 400) $logged = true;
if (strpos($resp, 'Logout') !== false || strpos($resp, 'Keluar') !== false) $logged = true;
if (!$logged) echo "Warning: login may have failed (no redirect / logout link detected)\n";

// 3) check routes with session cookie
foreach ($routes as $r) {
    $url = $base . $r;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie);
    $resp = curl_exec($ch);
    if ($resp === false) { echo sprintf("%-25s ERROR: %s\n", $r, curl_error($ch)); continue; }
    $info = curl_getinfo($ch);
    $header_size = $info['header_size'];
    $body = substr($resp, $header_size);
    $code = $info['http_code'];
    $preview = preg_replace('/\s+/', ' ', trim(substr($body,0,200)));
    echo sprintf("%-25s  %3d  %s\n", $r, $code, $preview) . PHP_EOL;
}

// cleanup
@unlink($cookie);
