<?php
$base = $argv[1] ?? 'http://localhost/cicilan/web/index.php?r=';
$routes = [
    'site/index', 'site/login',
    'barang/index', 'barang/create',
    'pelanggan/index', 'pelanggan/create',
    'kategori/index',
    'kontrak/index', 'kontrak/create',
    'pembayaran/index', 'pembayaran/create',
    'setting/index', 'setting/user', 'setting/prefix',
    'role/index', 'permission/index', 'user/index'
];
foreach ($routes as $r) {
    $url = $base . $r;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
    curl_setopt($ch, CURLOPT_HEADER, true);
    $resp = curl_exec($ch);
    if ($resp === false) {
        echo sprintf("% -30s  ERROR: %s\n", $r, curl_error($ch));
        continue;
    }
    $info = curl_getinfo($ch);
    $header_size = $info['header_size'];
    $body = substr($resp, $header_size);
    $code = $info['http_code'];
    $preview = preg_replace('/\s+/', ' ', trim(substr($body,0,200)));
    echo sprintf("%-25s  %3d  %s\n", $r, $code, $preview) . PHP_EOL;
    curl_close($ch);
}
