<?php
// first GET the form to obtain CSRF token and session cookie
$base = 'http://localhost/cicilan/web/index.php?r=pembayaran/create';
$ch = curl_init($base);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIEJAR, __DIR__ . '/cookiejar.txt');
$html = curl_exec($ch);
curl_close($ch);

// extract CSRF token from form HTML
$csrf = null;
if (preg_match('/name="_csrf"\s+value="([^"]+)"/', $html, $m)) {
    $csrf = $m[1];
} elseif (preg_match('/<meta\s+name="csrf-token"\s+content="([^"]+)"/', $html, $m2)) {
    $csrf = $m2[1];
}

$post = [
    'pelanggan_id' => 'PLG0011',
    'kontrak_id' => '4',
    'payments' => [
        [
            'kontrak_installment_id' => '',
            'amount' => '1000000',
            'paid_at' => '2025-12-11 17:28:55',
            'note' => 'Kelebihan bayar'
        ]
    ]
];
if ($csrf) $post['_csrf'] = $csrf;
$ch = curl_init('http://localhost/cicilan/web/index.php?r=pembayaran/create');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIEFILE, __DIR__ . '/cookiejar.txt');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'X-Requested-With: XMLHttpRequest',
    'Accept: application/json'
]);
$res = curl_exec($ch);
if ($res === false) {
    echo 'CURL ERROR: ' . curl_error($ch) . "\n";
} else {
    echo $res;
}
curl_close($ch);
