<?php
$kontrak_id = $argv[1] ?? '4';
$dbConfig = require __DIR__ . '/../config/db.php';
$dsn = $dbConfig['dsn'];
preg_match('/host=([^;]+);dbname=([^;]+)/', $dsn, $m);
$host = $m[1] ?? '127.0.0.1';
$dbname = $m[2] ?? 'cicilan';
$user = $dbConfig['username'] ?? 'root';
$pass = $dbConfig['password'] ?? '';
$mysqli = new mysqli($host, $user, $pass, $dbname);
if ($mysqli->connect_errno) { echo "DB connect error: " . $mysqli->connect_error . "\n"; exit(1); }
$mysqli->set_charset('utf8mb4');

$q = $mysqli->query("SELECT p.id,p.nomor,p.pelanggan_id,p.total_bayar,p.created_at, (SELECT COUNT(*) FROM pembayaran_item pi WHERE pi.pembayaran_id=p.id) as items_count FROM pembayaran p WHERE p.kontrak_id = " . intval($kontrak_id) . " ORDER BY p.created_at DESC");
if (!$q) { echo "Query error: " . $mysqli->error . "\n"; exit(1); }
$rows = [];
while ($r = $q->fetch_assoc()) $rows[] = $r;
if (empty($rows)) { echo "No pembayaran for kontrak_id={$kontrak_id}\n"; exit(0); }
foreach ($rows as $r) {
    echo "ID: {$r['id']} | Nomor: {$r['nomor']} | Pelanggan: {$r['pelanggan_id']} | Total: {$r['total_bayar']} | Items: {$r['items_count']} | Created: {$r['created_at']}\n";
}
$mysqli->close();
