<?php
// Cleanup script for zero-total pembayaran.
// Usage:
//  php cleanup_zero_total_pembayaran.php --dry-run
//  php cleanup_zero_total_pembayaran.php --delete --yes

$dbConfig = require __DIR__ . '/../config/db.php';
$dsn = $dbConfig['dsn'];
preg_match('/host=([^;]+);dbname=([^;]+)/', $dsn, $m);
$host = $m[1] ?? '127.0.0.1';
$dbname = $m[2] ?? 'cicilan';
$user = $dbConfig['username'] ?? 'root';
$pass = $dbConfig['password'] ?? '';

$mysqli = new mysqli($host, $user, $pass, $dbname);
if ($mysqli->connect_errno) {
    echo "DB connect error: " . $mysqli->connect_error . "\n";
    exit(1);
}
$mysqli->set_charset('utf8mb4');

$argv = $_SERVER['argv'] ?? [];
$dry = in_array('--dry-run', $argv);
$delete = in_array('--delete', $argv);
$yes = in_array('--yes', $argv);

echo "Cleanup zero-total pembayaran script\n";
if ($dry) echo "Mode: dry-run (no changes)\n";
if ($delete) echo "Mode: delete (will remove rows)\n";

$sql = "SELECT p.*, COALESCE(pi.cnt,0) AS items_count FROM pembayaran p LEFT JOIN (SELECT pembayaran_id, COUNT(*) cnt FROM pembayaran_item GROUP BY pembayaran_id) pi ON p.id = pi.pembayaran_id WHERE COALESCE(p.total_bayar,0) = 0";
$res = $mysqli->query($sql);
if (!$res) {
    echo "Query error: " . $mysqli->error . "\n";
    exit(1);
}

$rows = [];
while ($r = $res->fetch_assoc()) $rows[] = $r;
if (count($rows) === 0) {
    echo "No zero-total pembayaran found.\n";
    $mysqli->close();
    exit(0);
}

echo "Found " . count($rows) . " pembayaran(s) with total_bayar = 0:\n";
foreach ($rows as $r) {
    printf("ID:%s | Nomor:%s | Pelanggan:%s | Kontrak:%s | Total:%s | Items:%s | Created:%s\n",
        $r['id'],$r['nomor'],$r['pelanggan_id'],$r['kontrak_id'],$r['total_bayar'],$r['items_count'],$r['created_at']
    );
}

if (!$delete) {
    echo "\nDry-run complete. To delete these rows, re-run with --delete --yes\n";
    $mysqli->close();
    exit(0);
}

if ($delete && !$yes) {
    echo "To actually delete, add --yes to confirm. Aborting.\n";
    $mysqli->close();
    exit(2);
}

// proceed with deletion
echo "\nDeleting...\n";
$mysqli->begin_transaction();
try {
    $deleted = 0;
    foreach ($rows as $r) {
        $pid = intval($r['id']);
        $mysqli->query("DELETE FROM pembayaran_item WHERE pembayaran_id = $pid");
        if ($mysqli->errno) throw new Exception($mysqli->error);
        $mysqli->query("DELETE FROM pembayaran WHERE id = $pid LIMIT 1");
        if ($mysqli->errno) throw new Exception($mysqli->error);
        $deleted++;
        echo "Deleted pembayaran id=$pid\n";
    }
    $mysqli->commit();
    echo "Done. Deleted $deleted pembayaran(s).\n";
} catch (Exception $e) {
    $mysqli->rollback();
    echo "Error during delete: " . $e->getMessage() . "\n";
    $mysqli->close();
    exit(3);
}

$mysqli->close();
exit(0);
