<?php
namespace app\models;

use yii\db\ActiveRecord;

class Pembayaran extends ActiveRecord
{
    public static function tableName()
    {
        return 'pembayaran';
    }

    public function rules()
    {
        return [
            [['nomor','pelanggan_id','kontrak_id','created_at'],'required'],
            [['total_bayar'],'number'],
        ];
    }

    public function getItems()
    {
        return $this->hasMany(PembayaranItem::class, ['pembayaran_id'=>'id']);
    }

    public function getKontrak()
    {
        return $this->hasOne(\app\models\Kontrak::class, ['id' => 'kontrak_id']);
    }

    public function getPelanggan()
    {
        return $this->hasOne(\app\models\Pelanggan::class, ['kode_pelanggan' => 'pelanggan_id']);
    }
}
