<?php

namespace app\models;

use Yii;
use app\models\Setting;

/**
 * This is the model class for table "pelanggan".
 *
 * @property string $kode_pelanggan
 * @property string $nama
 * @property string|null $alias
 * @property string $no_ktp
 * @property string|null $no_whatsapp
 * @property string|null $no_handphone
 * @property string|null $alamat
 * @property string|null $sosial_media
 * @property string|null $referal
 * @property string|null $foto
 * @property string|null $foto_ktp
 * @property string|null $foto_lainnya
 * @property string|null $created_at
 */
class Pelanggan extends \yii\db\ActiveRecord
{
    public function beforeValidate()
    {
        if (!parent::beforeValidate()) {
            return false;
        }
        // no price field here, but ensure kode normalization if needed
        return true;
    }

    /**
     * Generate kode for pelanggan using prefix from settings or default PLG-
     * This computes the next numeric suffix based on existing `kode_pelanggan` values.
     */
    public function generateKode(?string $prefix = null): string
    {
        if ($prefix === null) {
            $prefix = Setting::get('prefix_pelanggan', 'PLG-');
        }

        $db = static::getDb();
        $sql = "SELECT MAX(CAST(SUBSTRING(kode_pelanggan, :pref_len_plus) AS UNSIGNED)) AS maxn
                FROM `pelanggan`
                WHERE kode_pelanggan LIKE :like";
        $pref_len_plus = strlen($prefix) + 1; // MySQL SUBSTRING is 1-based
        $stmt = $db->createCommand($sql, [
            ':pref_len_plus' => $pref_len_plus,
            ':like' => $prefix . '%',
        ])->queryOne();

        $maxn = isset($stmt['maxn']) ? (int)$stmt['maxn'] : 0;
        $next = $maxn + 1;
        $pad = str_pad((string)$next, 4, '0', STR_PAD_LEFT);
        return $prefix . $pad;
    }
    /** @var \yii\web\UploadedFile|null */
    public $fotoFile;
    /** @var \yii\web\UploadedFile|null */
    public $fotoKtpFile;
    /** @var array|null */
    public $fotoLainnyaFiles;


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'pelanggan';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['alias', 'no_whatsapp', 'no_handphone', 'alamat', 'sosial_media', 'referal', 'foto', 'foto_ktp', 'foto_lainnya'], 'default', 'value' => null],
            [['kode_pelanggan', 'nama', 'no_ktp'], 'required'],
            [['alamat', 'sosial_media', 'referal'], 'string'],
            [['created_at'], 'safe'],
            [['kode_pelanggan'], 'string', 'max' => 10],
            [['nama', 'alias', 'foto', 'foto_ktp', 'foto_lainnya'], 'string', 'max' => 255],
            [['fotoFile', 'fotoKtpFile'], 'file', 'skipOnEmpty' => true, 'extensions' => 'png, jpg, jpeg, gif', 'maxSize' => 5242880],
            [['fotoLainnyaFiles'], 'file', 'skipOnEmpty' => true, 'extensions' => 'png, jpg, jpeg, gif', 'maxSize' => 5242880, 'maxFiles' => 5],
            [['no_ktp', 'no_whatsapp', 'no_handphone'], 'string', 'max' => 50],
            [['kode_pelanggan'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'kode_pelanggan' => 'Kode Pelanggan',
            'nama' => 'Nama',
            'alias' => 'Alias',
            'no_ktp' => 'No. KTP',
            'no_whatsapp' => 'No. WhatsApp',
            'no_handphone' => 'No. Handphone',
            'alamat' => 'Alamat',
            'sosial_media' => 'Sosial Media',
            'referal' => 'Referal',
            'foto' => 'Foto',
            'foto_ktp' => 'Foto KTP',
            'foto_lainnya' => 'Foto Lainnya',
            'created_at' => 'Dibuat Pada',
        ];
    }

}
