<?php
namespace app\models;

use yii\base\Model;
use yii\web\UploadedFile;

class LogoForm extends Model
{
    /** @var UploadedFile */
    public $imageFile;

    public function rules()
    {
        return [
            [['imageFile'], 'file', 'skipOnEmpty' => false, 'extensions' => 'png, jpg, jpeg, gif', 'maxSize' => 1024 * 1024 * 2],
        ];
    }

    public function upload()
    {
        if (!$this->validate()) return false;
        $dir = \Yii::getAlias('@webroot') . DIRECTORY_SEPARATOR . 'uploads';
        if (!is_dir($dir)) mkdir($dir, 0755, true);
        $filePath = $dir . DIRECTORY_SEPARATOR . 'logo.png';
        // always save as PNG to keep consistent
        $this->imageFile->saveAs($filePath);
        return true;
    }
}
