<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

class KontrakItem extends ActiveRecord
{
    public static function tableName()
    {
        return 'kontrak_item';
    }

    public function rules()
    {
        return [
            [['kontrak_id'],'integer'],
            [['barang_id'],'string','max'=>64],
            [['qty'],'integer','min'=>1],
            [['harga'],'number'],
            [['keterangan'],'string','max'=>255],
        ];
    }

    public function getBarang()
    {
        return $this->hasOne(Barang::class, ['kode_barang'=>'barang_id']);
    }
}
