<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * Model for kontrak
 */
class Kontrak extends ActiveRecord
{
    public static function tableName()
    {
        return 'kontrak';
    }

    public function rules()
    {
        return [
            [['nomor','pelanggan_id','tanggal_mulai'],'required'],
            [['pelanggan_id'],'string','max'=>64],
            [['tenor'],'integer'],
            [['dp','margin_per_week','total_harga','custom_installment_amount'],'number'],
            [['tenor_unit'],'in','range'=>['week','month']],
            [['is_custom_installment'],'boolean'],
            [['created_at'],'safe'],
        ];
    }

    public function getItems()
    {
        return $this->hasMany(KontrakItem::class, ['kontrak_id'=>'id']);
    }

    public function getInstallments()
    {
        return $this->hasMany(KontrakInstallment::class, ['kontrak_id'=>'id'])->orderBy(['periode'=>SORT_ASC]);
    }

    public function getPelanggan()
    {
        return $this->hasOne(Pelanggan::class, ['kode_pelanggan'=>'pelanggan_id']);
    }
}
