<?php

use yii\db\Migration;

class m260211_000000_create_pembayaran_tables extends Migration
{
    public function safeUp()
    {
        // create pembayaran table if not exists
        if ($this->db->schema->getTableSchema('{{%pembayaran}}', true) === null) {
            $this->createTable('{{%pembayaran}}', [
                'id' => $this->primaryKey(),
                'nomor' => $this->string(64)->notNull(),
                'pelanggan_id' => $this->string(64)->notNull(),
                'kontrak_id' => $this->integer()->notNull(),
                'total_paid' => $this->decimal(14,2)->notNull()->defaultValue(0),
                'created_at' => $this->dateTime()->notNull(),
            ]);
        }

        // create pembayaran_item table if not exists
        if ($this->db->schema->getTableSchema('{{%pembayaran_item}}', true) === null) {
            $this->createTable('{{%pembayaran_item}}', [
                'id' => $this->primaryKey(),
                'pembayaran_id' => $this->integer()->notNull(),
                'installment_id' => $this->integer()->notNull(),
                'amount' => $this->decimal(14,2)->notNull()->defaultValue(0),
                'paid_at' => $this->dateTime()->notNull(),
                'note' => $this->string(255)->null(),
            ]);
        }

        // add foreign key if not exists
        $table = $this->db->schema->getTableSchema('{{%pembayaran_item}}', true);
        $hasFk = false;
        if ($table !== null) {
            foreach ($table->foreignKeys as $fk) {
                if (isset($fk[0]) && $fk[0] === 'pembayaran') { $hasFk = true; break; }
            }
        }
        if (!$hasFk) {
            // use try/catch to avoid duplicate fk errors on some DBs
            try {
                $this->addForeignKey('fk_pembayaran_item_pembayaran', '{{%pembayaran_item}}', 'pembayaran_id', '{{%pembayaran}}', 'id', 'CASCADE', 'CASCADE');
            } catch (\Exception $e) {
                // ignore
            }
        }
    }

    public function safeDown()
    {
        $this->dropForeignKey('fk_pembayaran_item_pembayaran', '{{%pembayaran_item}}');
        $this->dropTable('{{%pembayaran_item}}');
        $this->dropTable('{{%pembayaran}}');
    }
}
