<?php

use yii\db\Migration;

class m251213_000004_map_admin_permissions extends Migration
{
    public function safeUp()
    {
        $roleId = (new \yii\db\Query())->select('id')->from('{{%role}}')->where(['name' => 'admin'])->scalar();
        if (!$roleId) return;
        $permissionIds = (new \yii\db\Query())->select('id')->from('{{%permission}}')->column();
        foreach ($permissionIds as $pid) {
            $exists = (new \yii\db\Query())->from('{{%role_permission}}')->where(['role_id' => $roleId, 'permission_id' => $pid])->exists();
            if (!$exists) {
                $this->insert('{{%role_permission}}', ['role_id' => $roleId, 'permission_id' => $pid]);
            }
        }
    }

    public function safeDown()
    {
        $roleId = (new \yii\db\Query())->select('id')->from('{{%role}}')->where(['name' => 'admin'])->scalar();
        if (!$roleId) return;
        $this->delete('{{%role_permission}}', ['role_id' => $roleId]);
    }
}
