<?php

use yii\db\Migration;

class m251213_000003_add_default_permissions extends Migration
{
    public function safeUp()
    {
        $menus = ['barang', 'pelanggan', 'kontrak', 'pembayaran', 'pengaturan'];
        $actions = [
            'view' => 'Lihat',
            'create' => 'Tambah',
            'update' => 'Ubah',
            'delete' => 'Hapus',
            'print' => 'Cetak',
            'approve' => 'Approve',
        ];

        foreach ($menus as $m) {
            foreach ($actions as $a => $label) {
                $name = $m . '.' . $a;
                // avoid duplicate insert
                $exists = (new \yii\db\Query())->from('{{%permission}}')->where(['name' => $name])->exists();
                if (!$exists) {
                    $this->insert('{{%permission}}', ['name' => $name, 'description' => $m . ' - ' . $label]);
                }
            }
        }
    }

    public function safeDown()
    {
        $menus = ['barang', 'pelanggan', 'kontrak', 'pembayaran', 'pengaturan'];
        $actions = ['view','create','update','delete','print','approve'];
        foreach ($menus as $m) {
            foreach ($actions as $a) {
                $name = $m . '.' . $a;
                $this->delete('{{%permission}}', ['name' => $name]);
            }
        }
    }
}
