<?php

use yii\db\Migration;

class m251213_000002_create_role_permission_tables extends Migration
{
    public function safeUp()
    {
        $this->createTable('{{%role}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string()->notNull()->unique(),
            'description' => $this->string()->null(),
        ]);

        $this->createTable('{{%permission}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string()->notNull()->unique(),
            'description' => $this->string()->null(),
        ]);

        $this->createTable('{{%role_permission}}', [
            'role_id' => $this->integer()->notNull(),
            'permission_id' => $this->integer()->notNull(),
            'PRIMARY KEY(role_id, permission_id)'
        ]);

        $this->addForeignKey('fk_role_permission_role', '{{%role_permission}}', 'role_id', '{{%role}}', 'id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('fk_role_permission_permission', '{{%role_permission}}', 'permission_id', '{{%permission}}', 'id', 'CASCADE', 'CASCADE');

        // seed basic roles and permissions
        $this->insert('{{%role}}', ['name' => 'admin', 'description' => 'Administrator']);
        $this->insert('{{%role}}', ['name' => 'user', 'description' => 'Regular user']);

        $perms = [
            ['name' => 'manageUsers', 'description' => 'Manage users and roles'],
            ['name' => 'manageSettings', 'description' => 'Manage application settings'],
            ['name' => 'viewPayments', 'description' => 'View payments'],
            ['name' => 'editPayments', 'description' => 'Create/edit payments'],
        ];
        foreach ($perms as $p) {
            $this->insert('{{%permission}}', $p);
        }

        // map admin -> all permissions
        $roleAdmin = (new \yii\db\Query())->select('id')->from('{{%role}}')->where(['name'=>'admin'])->scalar();
        $permissionIds = (new \yii\db\Query())->select('id')->from('{{%permission}}')->column();
        foreach ($permissionIds as $pid) {
            $this->insert('{{%role_permission}}', ['role_id' => $roleAdmin, 'permission_id' => $pid]);
        }
    }

    public function safeDown()
    {
        $this->dropForeignKey('fk_role_permission_permission', '{{%role_permission}}');
        $this->dropForeignKey('fk_role_permission_role', '{{%role_permission}}');
        $this->dropTable('{{%role_permission}}');
        $this->dropTable('{{%permission}}');
        $this->dropTable('{{%role}}');
    }
}
