<?php

use yii\db\Migration;

class m251211_120000_create_kontrak_tables extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('kontrak', [
            'id' => $this->primaryKey(),
            'nomor' => $this->string(64)->notNull()->unique(),
            'pelanggan_id' => $this->integer()->notNull(),
            'tanggal_mulai' => $this->date()->notNull(),
            'dp' => $this->decimal(14,2)->notNull()->defaultValue(0),
            'margin_per_week' => $this->decimal(6,3)->notNull()->defaultValue(2.0),
            'tenor' => $this->integer()->notNull()->defaultValue(10),
            'tenor_unit' => "ENUM('week','month') NOT NULL DEFAULT 'week'",
            'total_harga' => $this->decimal(14,2)->notNull()->defaultValue(0),
            'is_custom_installment' => $this->tinyInteger(1)->notNull()->defaultValue(0),
            'custom_installment_amount' => $this->decimal(14,2)->null(),
            'created_at' => $this->dateTime()->notNull(),
        ], $tableOptions);

        $this->createIndex('idx-kontrak-pelanggan', 'kontrak', 'pelanggan_id');

        $this->createTable('kontrak_item', [
            'id' => $this->primaryKey(),
            'kontrak_id' => $this->integer()->notNull(),
            'barang_id' => $this->integer()->notNull(),
            'qty' => $this->integer()->notNull()->defaultValue(1),
            'harga' => $this->decimal(14,2)->notNull()->defaultValue(0),
            'keterangan' => $this->string(255)->null(),
        ], $tableOptions);

        $this->addForeignKey('fk-kontrakitem-kontrak', 'kontrak_item', 'kontrak_id', 'kontrak', 'id', 'CASCADE', 'CASCADE');

        $this->createTable('kontrak_installment', [
            'id' => $this->primaryKey(),
            'kontrak_id' => $this->integer()->notNull(),
            'periode' => $this->integer()->notNull(),
            'due_date' => $this->date()->notNull(),
            'amount' => $this->decimal(14,2)->notNull()->defaultValue(0),
            'paid' => $this->tinyInteger(1)->notNull()->defaultValue(0),
        ], $tableOptions);

        $this->addForeignKey('fk-install-kontrak', 'kontrak_installment', 'kontrak_id', 'kontrak', 'id', 'CASCADE', 'CASCADE');
    }

    public function safeDown()
    {
        $this->dropForeignKey('fk-install-kontrak', 'kontrak_installment');
        $this->dropTable('kontrak_installment');
        $this->dropForeignKey('fk-kontrakitem-kontrak', 'kontrak_item');
        $this->dropTable('kontrak_item');
        $this->dropTable('kontrak');
    }
}
